/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.message.DescribeClusterLinksRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterLinksResponse;

public class DescribeClusterLinksRequest
extends AbstractRequest {
    public static final short NEWEST_ALLOWED_VERSION_CONTROLLER_HANDLING = 3;
    public static final short OLDEST_ALLOWED_VERSION_LINK_COORDINATOR_HANDLING = 4;
    private final DescribeClusterLinksRequestData data;

    public DescribeClusterLinksRequest(DescribeClusterLinksRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CLUSTER_LINKS, version);
        this.data = data;
    }

    public Optional<List<String>> linkNames() {
        return Optional.ofNullable(this.data.linkNames());
    }

    public boolean includeTopics() {
        return this.data.includeTopics();
    }

    public boolean includeTasks() {
        return this.data.includeTasks();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public DescribeClusterLinksResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeClusterLinksResponse(throttleTimeMs, e);
    }

    @Override
    public DescribeClusterLinksRequestData data() {
        return this.data;
    }

    public static DescribeClusterLinksRequest parse(Readable readable, short version, MessageContext context) {
        return new DescribeClusterLinksRequest(new DescribeClusterLinksRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeClusterLinksRequest> {
        private final DescribeClusterLinksRequestData data;

        public Builder(Optional<Collection<String>> linkNames, boolean includeTopics, boolean includeTasks, int timeoutMs) {
            super(ApiKeys.DESCRIBE_CLUSTER_LINKS);
            this.data = new DescribeClusterLinksRequestData().setLinkNames(linkNames.map(names -> new ArrayList(names)).orElse(null)).setIncludeTopics(includeTopics).setIncludeTasks(includeTasks).setTimeoutMs(timeoutMs);
        }

        public Builder(Optional<Collection<String>> linkNames, boolean includeTopics, boolean includeTasks, int timeoutMs, short oldestAllowedVersion, short newestAllowedVersion) {
            super(ApiKeys.DESCRIBE_CLUSTER_LINKS, oldestAllowedVersion, newestAllowedVersion);
            this.data = new DescribeClusterLinksRequestData().setLinkNames(linkNames.map(names -> new ArrayList(names)).orElse(null)).setIncludeTopics(includeTopics).setIncludeTasks(includeTasks).setTimeoutMs(timeoutMs);
        }

        @Override
        public DescribeClusterLinksRequest build(short version) {
            return new DescribeClusterLinksRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

