/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AlterBrokerReplicaExclusionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterBrokerReplicaExclusionsResponse
extends AbstractResponse {
    private final AlterBrokerReplicaExclusionsResponseData data;

    public AlterBrokerReplicaExclusionsResponse(AlterBrokerReplicaExclusionsResponseData responseData) {
        super(ApiKeys.ALTER_BROKER_REPLICA_EXCLUSIONS);
        this.data = responseData;
    }

    @Override
    public AlterBrokerReplicaExclusionsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            return Collections.singletonMap(Errors.forCode(this.data.errorCode()), this.data.brokerExclusions().size());
        }
        return AlterBrokerReplicaExclusionsResponse.errorCounts(this.data.brokerExclusions().stream().map(p -> Errors.forCode(p.exclusionErrorCode())).collect(Collectors.toList()));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static AlterBrokerReplicaExclusionsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterBrokerReplicaExclusionsResponse(new AlterBrokerReplicaExclusionsResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterBrokerReplicaExclusionsResponse that = (AlterBrokerReplicaExclusionsResponse)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

