/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.AbstractRecordBatch;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.LogInputStream;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Utils;

public class RemoteLogInputStream
implements LogInputStream<RecordBatch> {
    private final InputStream inputStream;
    private final ByteBuffer logHeaderBuffer = ByteBuffer.allocate(17);

    public RemoteLogInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public RecordBatch nextBatch() throws IOException {
        this.logHeaderBuffer.clear();
        Utils.readFully(this.inputStream, this.logHeaderBuffer, false);
        if (this.logHeaderBuffer.position() < 17) {
            return null;
        }
        this.logHeaderBuffer.rewind();
        int size = this.logHeaderBuffer.getInt(8);
        if (size < 14) {
            throw new CorruptRecordException(String.format("Found record size %d smaller than minimum record overhead (%d).", size, 14));
        }
        int bufferSize = 12 + size;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.put(this.logHeaderBuffer);
        Utils.readFully(this.inputStream, buffer, false);
        if (buffer.position() != bufferSize) {
            return null;
        }
        buffer.rewind();
        byte magic = this.logHeaderBuffer.get(16);
        AbstractRecordBatch batch = magic > 1 ? new DefaultRecordBatch(buffer) : new AbstractLegacyRecordBatch.ByteBufferLegacyRecordBatch(buffer);
        return batch;
    }
}

