/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import java.util.HashMap;

public enum AclState {
    UNKNOWN(0),
    ACTIVE(1),
    DELETED(2),
    ANY(3);

    private static final HashMap<Byte, AclState> CODE_TO_VALUE;
    private final byte code;

    private AclState(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public static AclState fromCode(byte code) {
        AclState aclState = CODE_TO_VALUE.getOrDefault(code, UNKNOWN);
        return aclState;
    }

    public boolean isActive() {
        return this == ACTIVE;
    }

    public boolean isDeleted() {
        return this == DELETED;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    static {
        CODE_TO_VALUE = new HashMap();
        for (AclState aclState : AclState.values()) {
            CODE_TO_VALUE.put(aclState.code, aclState);
        }
    }
}

