/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.nio.ByteBuffer;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.Crc32CUtil;

public final class Crc32C {
    private Crc32C() {
    }

    public static long compute(byte[] bytes, int offset, int size) {
        CRC32C crc = new CRC32C();
        crc.update(bytes, offset, size);
        return crc.getValue();
    }

    public static long compute(ByteBuffer buffer, int offset, int size) {
        CRC32C crc = new CRC32C();
        Checksums.update(crc, buffer, offset, size);
        return crc.getValue();
    }

    public static Checksum create(int crc) {
        return Crc32CUtil.feedRegister(new CRC32C(), crc);
    }
}

