/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.DeleteTenantsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DeleteTenantsResponse
extends AbstractResponse {
    private final DeleteTenantsResponseData data;

    public DeleteTenantsResponse(DeleteTenantsResponseData data) {
        super(ApiKeys.DELETE_TENANTS);
        this.data = data;
    }

    @Override
    public DeleteTenantsResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        DeleteTenantsResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        return counts;
    }

    List<String> getFailedTenants() {
        return this.data.failedTenants();
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public static DeleteTenantsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DeleteTenantsResponse(new DeleteTenantsResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

