/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ControllerRegistrationResponse;

public class ControllerRegistrationRequest
extends AbstractRequest {
    private final ControllerRegistrationRequestData data;

    public ControllerRegistrationRequest(ControllerRegistrationRequestData data, short version) {
        super(ApiKeys.CONTROLLER_REGISTRATION, version);
        this.data = data;
    }

    @Override
    public ControllerRegistrationRequestData data() {
        return this.data;
    }

    @Override
    public ControllerRegistrationResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new ControllerRegistrationResponse(new ControllerRegistrationResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setErrorMessage(error.message()));
    }

    public static ControllerRegistrationRequest parse(Readable readable, short version, MessageContext context) {
        return new ControllerRegistrationRequest(new ControllerRegistrationRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ControllerRegistrationRequest> {
        private final ControllerRegistrationRequestData data;

        public Builder(ControllerRegistrationRequestData data) {
            super(ApiKeys.CONTROLLER_REGISTRATION);
            this.data = data;
        }

        @Override
        public ControllerRegistrationRequest build(short version) {
            return new ControllerRegistrationRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

