/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.List;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.RawTaggedField;

public interface Message {
    public short lowestSupportedVersion();

    public short highestSupportedVersion();

    default public int size(ObjectSerializationCache cache, short version, MessageContext context) {
        MessageSizeAccumulator size = new MessageSizeAccumulator();
        this.addSize(size, cache, version, context);
        return size.totalSize();
    }

    default public int size(ObjectSerializationCache cache, short version) {
        return this.size(cache, version, MessageContext.IDENTITY);
    }

    public void addSize(MessageSizeAccumulator var1, ObjectSerializationCache var2, short var3, MessageContext var4);

    default public void addSize(MessageSizeAccumulator size, ObjectSerializationCache cache, short version) {
        this.addSize(size, cache, version, MessageContext.IDENTITY);
    }

    public void write(Writable var1, ObjectSerializationCache var2, short var3, MessageContext var4);

    default public void write(Writable writable, ObjectSerializationCache cache, short version) {
        this.write(writable, cache, version, MessageContext.IDENTITY);
    }

    public void read(Readable var1, short var2, MessageContext var3);

    default public void read(Readable readable, short version) {
        this.read(readable, version, MessageContext.IDENTITY);
    }

    public List<RawTaggedField> unknownTaggedFields();

    public Message duplicate();
}

