/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;

public abstract class AbstractGaugeSuite<K, T>
implements AutoCloseable {
    protected final Logger log;
    protected final String suiteName;
    protected final Metrics metrics;
    protected final Function<K, MetricName> metricNameCalculator;
    protected final Map<K, StoredGauge<T>> gauges;
    protected final ConcurrentLinkedDeque<PendingMetricsChange> pending;
    protected final Lock modifyMetricsLock;
    protected boolean closed;

    public AbstractGaugeSuite(Logger log, String suiteName, Metrics metrics, Function<K, MetricName> metricNameCalculator) {
        this.log = log;
        this.suiteName = suiteName;
        this.metrics = metrics;
        this.metricNameCalculator = metricNameCalculator;
        this.gauges = new HashMap<K, StoredGauge<T>>(1);
        this.pending = new ConcurrentLinkedDeque();
        this.modifyMetricsLock = new ReentrantLock();
        this.closed = false;
        log.trace("{}: created new gauge suite.", (Object)suiteName);
    }

    protected void performPendingMetricsOperations() {
        this.modifyMetricsLock.lock();
        try {
            this.log.trace("{}: entering performPendingMetricsOperations", (Object)this.suiteName);
            PendingMetricsChange change = this.pending.pollLast();
            while (change != null) {
                if (change.provider == null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("{}: removing metric {}", (Object)this.suiteName, (Object)change.metricName);
                    }
                    this.metrics.removeMetric(change.metricName);
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("{}: adding metric {}", (Object)this.suiteName, (Object)change.metricName);
                    }
                    this.metrics.addMetric(change.metricName, change.provider);
                }
                change = this.pending.pollLast();
            }
            this.log.trace("{}: leaving performPendingMetricsOperations", (Object)this.suiteName);
        }
        finally {
            this.modifyMetricsLock.unlock();
        }
    }

    protected void addGauge(K key, T value) {
        MetricName metricNameToAdd = this.metricNameCalculator.apply(key);
        StoredGauge<T> gauge = new StoredGauge<T>(metricNameToAdd, value);
        this.gauges.put(key, gauge);
        this.pending.push(new PendingMetricsChange(metricNameToAdd, gauge));
        this.log.trace("{}: Adding a new metric {}.", (Object)this.suiteName, (Object)key.toString());
    }

    protected void removeGauge(K key) {
        MetricName metricNameToRemove = this.gauges.get(key).metricName();
        this.gauges.remove(key);
        this.pending.push(new PendingMetricsChange(metricNameToRemove, null));
        this.log.trace("{}: Removing the metric {}, which has a value of 0.", (Object)this.suiteName, (Object)key.toString());
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            this.log.trace("{}: gauge suite is already closed.", (Object)this.suiteName);
            return;
        }
        this.closed = true;
        int prevSize = 0;
        Iterator<StoredGauge<T>> iter = this.gauges.values().iterator();
        while (iter.hasNext()) {
            this.pending.push(new PendingMetricsChange(iter.next().metricName, null));
            ++prevSize;
            iter.remove();
        }
        this.performPendingMetricsOperations();
        this.log.trace("{}: closed {} metric(s).", (Object)this.suiteName, (Object)prevSize);
    }

    Metrics metrics() {
        return this.metrics;
    }

    synchronized Map<K, T> values() {
        HashMap<K, T> values = new HashMap<K, T>();
        for (Map.Entry<K, StoredGauge<T>> entry : this.gauges.entrySet()) {
            values.put(entry.getKey(), entry.getValue().value());
        }
        return values;
    }

    public Set<K> keySet() {
        return this.gauges.keySet();
    }

    protected static class PendingMetricsChange {
        private final MetricName metricName;
        private final MetricValueProvider<?> provider;

        PendingMetricsChange(MetricName metricName, MetricValueProvider<?> provider) {
            this.metricName = metricName;
            this.provider = provider;
        }
    }

    protected static class StoredGauge<T>
    implements Gauge<T> {
        protected final MetricName metricName;
        protected T value;

        StoredGauge(MetricName metricName, T value) {
            this.metricName = metricName;
            this.value = value;
        }

        @Override
        public synchronized T value(MetricConfig config, long now) {
            return this.value;
        }

        synchronized T update(T value) {
            this.value = value;
            return this.value;
        }

        synchronized T value() {
            return this.value;
        }

        MetricName metricName() {
            return this.metricName;
        }
    }
}

