/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.AbstractHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.metrics.HeartbeatMetricsManager;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;

public class ShareHeartbeatRequestManager
extends AbstractHeartbeatRequestManager<ShareGroupHeartbeatResponse> {
    private final ShareMembershipManager membershipManager;
    private final HeartbeatState heartbeatState;
    public static final String SHARE_PROTOCOL_NOT_SUPPORTED_MSG = "The cluster does not support the share group protocol. To use share groups, the cluster must have the share group protocol enabled.";

    public ShareHeartbeatRequestManager(LogContext logContext, Time time, ConsumerConfig config, CoordinatorRequestManager coordinatorRequestManager, SubscriptionState subscriptions, ShareMembershipManager membershipManager, BackgroundEventHandler backgroundEventHandler, Metrics metrics) {
        super(logContext, time, config, coordinatorRequestManager, backgroundEventHandler, new HeartbeatMetricsManager(metrics, "consumer-share"));
        this.membershipManager = membershipManager;
        this.heartbeatState = new HeartbeatState(subscriptions, membershipManager);
    }

    ShareHeartbeatRequestManager(LogContext logContext, Timer timer, ConsumerConfig config, CoordinatorRequestManager coordinatorRequestManager, ShareMembershipManager membershipManager, HeartbeatState heartbeatState, AbstractHeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState, BackgroundEventHandler backgroundEventHandler, Metrics metrics) {
        super(logContext, timer, config, coordinatorRequestManager, heartbeatRequestState, backgroundEventHandler, new HeartbeatMetricsManager(metrics, "consumer-share"));
        this.membershipManager = membershipManager;
        this.heartbeatState = heartbeatState;
    }

    @Override
    public boolean handleSpecificFailure(Throwable exception) {
        boolean errorHandled = false;
        if (exception instanceof UnsupportedVersionException) {
            this.logger.error("{} failed due to {}: {}", new Object[]{this.heartbeatRequestName(), exception.getMessage(), SHARE_PROTOCOL_NOT_SUPPORTED_MSG});
            this.handleFatalFailure(new UnsupportedVersionException(SHARE_PROTOCOL_NOT_SUPPORTED_MSG, exception));
            errorHandled = true;
        }
        return errorHandled;
    }

    @Override
    public boolean handleSpecificExceptionInResponse(ShareGroupHeartbeatResponse response, long currentTimeMs) {
        boolean errorHandled;
        Errors error = this.errorForResponse(response);
        switch (error) {
            case UNSUPPORTED_VERSION: {
                this.logger.error("{} failed due to unsupported version: {}", (Object)this.heartbeatRequestName(), (Object)SHARE_PROTOCOL_NOT_SUPPORTED_MSG);
                this.handleFatalFailure(error.exception(SHARE_PROTOCOL_NOT_SUPPORTED_MSG));
                errorHandled = true;
                break;
            }
            default: {
                errorHandled = false;
            }
        }
        return errorHandled;
    }

    @Override
    public void resetHeartbeatState() {
        this.heartbeatState.reset();
    }

    @Override
    public NetworkClientDelegate.UnsentRequest buildHeartbeatRequest() {
        return new NetworkClientDelegate.UnsentRequest(new ShareGroupHeartbeatRequest.Builder(this.heartbeatState.buildRequestData()), this.coordinatorRequestManager.coordinator());
    }

    @Override
    public String heartbeatRequestName() {
        return "ShareGroupHeartbeatRequest";
    }

    @Override
    public Errors errorForResponse(ShareGroupHeartbeatResponse response) {
        return Errors.forCode(response.data().errorCode());
    }

    @Override
    public String errorMessageForResponse(ShareGroupHeartbeatResponse response) {
        return response.data().errorMessage();
    }

    @Override
    public long heartbeatIntervalForResponse(ShareGroupHeartbeatResponse response) {
        return response.data().heartbeatIntervalMs();
    }

    public ShareMembershipManager membershipManager() {
        return this.membershipManager;
    }

    static class HeartbeatState {
        private final SubscriptionState subscriptions;
        private final ShareMembershipManager shareMembershipManager;
        private final SentFields sentFields;

        public HeartbeatState(SubscriptionState subscriptions, ShareMembershipManager shareMembershipManager) {
            this.subscriptions = subscriptions;
            this.shareMembershipManager = shareMembershipManager;
            this.sentFields = new SentFields();
        }

        public void reset() {
            this.sentFields.reset();
        }

        public ShareGroupHeartbeatRequestData buildRequestData() {
            ShareGroupHeartbeatRequestData data = new ShareGroupHeartbeatRequestData();
            data.setGroupId(this.shareMembershipManager.groupId());
            data.setMemberId(this.shareMembershipManager.memberId());
            data.setMemberEpoch(this.shareMembershipManager.memberEpoch());
            if (this.sentFields.rackId == null) {
                data.setRackId(this.shareMembershipManager.rackId());
                this.sentFields.rackId = this.shareMembershipManager.rackId();
            }
            boolean sendAllFields = this.shareMembershipManager.state() == MemberState.JOINING;
            TreeSet<String> subscribedTopicNames = new TreeSet<String>(this.subscriptions.subscription());
            if (sendAllFields || !subscribedTopicNames.equals(this.sentFields.subscribedTopicNames)) {
                data.setSubscribedTopicNames(new ArrayList<String>(this.subscriptions.subscription()));
                this.sentFields.subscribedTopicNames = subscribedTopicNames;
            }
            return data;
        }

        static class SentFields {
            private String rackId = null;
            private TreeSet<String> subscribedTopicNames = null;

            SentFields() {
            }

            void reset() {
                this.rackId = null;
                this.subscribedTopicNames = null;
            }
        }
    }
}

