/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeBrokerRemovalsResult {
    private final KafkaFuture<Map<Integer, BrokerRemovalDescription>> futures;

    DescribeBrokerRemovalsResult(KafkaFuture<Map<Integer, BrokerRemovalDescription>> brokerRemovals) {
        this.futures = brokerRemovals;
    }

    public KafkaFuture<Map<Integer, BrokerRemovalDescription>> descriptions() {
        return this.futures;
    }

    public KafkaFuture<Optional<BrokerRemovalDescription>> description(int brokerId) {
        return this.futures.thenApply(desc -> Optional.ofNullable((BrokerRemovalDescription)desc.get(brokerId)));
    }
}

