/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;

public final class AdminBootstrapAddresses {
    private final boolean usingBootstrapControllers;
    private final List<InetSocketAddress> addresses;

    AdminBootstrapAddresses(boolean usingBootstrapControllers, List<InetSocketAddress> addresses) {
        this.usingBootstrapControllers = usingBootstrapControllers;
        this.addresses = addresses;
    }

    public boolean usingBootstrapControllers() {
        return this.usingBootstrapControllers;
    }

    public List<InetSocketAddress> addresses() {
        return this.addresses;
    }

    public static AdminBootstrapAddresses fromConfig(AbstractConfig config) {
        List<String> controllerServers;
        List<String> bootstrapServers = config.getList("bootstrap.servers");
        if (bootstrapServers == null) {
            bootstrapServers = Collections.emptyList();
        }
        if ((controllerServers = config.getList("bootstrap.controllers")) == null) {
            controllerServers = Collections.emptyList();
        }
        String clientDnsLookupConfig = config.getString("client.dns.lookup");
        if (bootstrapServers.isEmpty()) {
            if (controllerServers.isEmpty()) {
                throw new ConfigException("You must set either bootstrap.servers or bootstrap.controllers");
            }
            return new AdminBootstrapAddresses(true, ClientUtils.parseAndValidateAddresses(controllerServers, clientDnsLookupConfig));
        }
        if (controllerServers.isEmpty()) {
            return new AdminBootstrapAddresses(false, ClientUtils.parseAndValidateAddresses(bootstrapServers, clientDnsLookupConfig));
        }
        throw new ConfigException("You cannot set both bootstrap.servers and bootstrap.controllers");
    }

    public int hashCode() {
        return Objects.hash(this.usingBootstrapControllers, this.addresses);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(AdminBootstrapAddresses.class)) {
            return false;
        }
        AdminBootstrapAddresses other = (AdminBootstrapAddresses)o;
        return this.usingBootstrapControllers == other.usingBootstrapControllers && this.addresses.equals(other.addresses);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("AdminBootstrapAddresses");
        bld.append("(usingBoostrapControllers=").append(this.usingBootstrapControllers);
        bld.append(", addresses=[");
        String prefix = "";
        for (InetSocketAddress address : this.addresses) {
            bld.append(prefix).append(address);
            prefix = ", ";
        }
        bld.append("])");
        return bld.toString();
    }
}

