/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.AllowedPaths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class AllowedPathsTest {
    private AllowedPaths allowedPaths;
    @TempDir
    private File parent;
    private String dir;
    private String myFile;
    private String dir2;

    AllowedPathsTest() {
    }

    @BeforeEach
    public void setup() throws IOException {
        this.dir = Files.createDirectory(Paths.get(this.parent.toString(), "dir"), new FileAttribute[0]).toString();
        this.myFile = Files.createFile(Paths.get(this.dir, "myFile"), new FileAttribute[0]).toString();
        this.dir2 = Files.createDirectory(Paths.get(this.parent.toString(), "dir2"), new FileAttribute[0]).toString();
    }

    @Test
    public void testAllowedPath() {
        this.allowedPaths = new AllowedPaths(String.join((CharSequence)",", this.dir, this.dir2));
        Path actual = this.allowedPaths.parseUntrustedPath(this.myFile);
        Assertions.assertEquals((Object)this.myFile, (Object)actual.toString());
    }

    @Test
    public void testNotAllowedPath() {
        this.allowedPaths = new AllowedPaths(this.dir);
        Path actual = this.allowedPaths.parseUntrustedPath(this.dir2);
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testNullAllowedPaths() {
        this.allowedPaths = new AllowedPaths(null);
        Path actual = this.allowedPaths.parseUntrustedPath(this.myFile);
        Assertions.assertEquals((Object)this.myFile, (Object)actual.toString());
    }

    @Test
    public void testNoTraversal() {
        this.allowedPaths = new AllowedPaths(this.dir);
        Path traversedPath = Paths.get(this.dir, "..", "dir2");
        Path actual = this.allowedPaths.parseUntrustedPath(traversedPath.toString());
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testAllowedTraversal() {
        this.allowedPaths = new AllowedPaths(String.join((CharSequence)",", this.dir, this.dir2));
        Path traversedPath = Paths.get(this.dir, "..", "dir2");
        Path actual = this.allowedPaths.parseUntrustedPath(traversedPath.toString());
        Assertions.assertEquals((Object)traversedPath.normalize(), (Object)actual);
    }

    @Test
    public void testNullAllowedPathsTraversal() {
        this.allowedPaths = new AllowedPaths("");
        Path traversedPath = Paths.get(this.dir, "..", "dir2");
        Path actual = this.allowedPaths.parseUntrustedPath(traversedPath.toString());
        Assertions.assertEquals((Object)traversedPath, (Object)actual);
    }

    @Test
    public void testAllowedPathDoesNotExist() {
        Exception e = (Exception)Assertions.assertThrows(ConfigException.class, () -> new AllowedPaths("/foo"));
        Assertions.assertEquals((Object)"Path /foo does not exist", (Object)e.getMessage());
    }

    @Test
    public void testAllowedPathIsNotAbsolute() {
        Exception e = (Exception)Assertions.assertThrows(ConfigException.class, () -> new AllowedPaths("foo bar "));
        Assertions.assertEquals((Object)"Path foo bar  is not absolute", (Object)e.getMessage());
    }
}

