/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.ShareCompletedFetch;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsAggregator;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ShareFetchBufferTest {
    private final Time time = new MockTime(0L, 0L, 0L);
    private final TopicIdPartition topicAPartition0 = new TopicIdPartition(Uuid.randomUuid(), 0, "topic-a");
    private final TopicIdPartition topicAPartition1 = new TopicIdPartition(Uuid.randomUuid(), 1, "topic-a");
    private final TopicIdPartition topicAPartition2 = new TopicIdPartition(Uuid.randomUuid(), 2, "topic-a");
    private final Set<TopicIdPartition> allPartitions = ShareFetchBufferTest.partitions(this.topicAPartition0, this.topicAPartition1, this.topicAPartition2);
    private LogContext logContext;
    private ShareFetchMetricsManager shareFetchMetricsManager;

    @BeforeEach
    public void setup() {
        this.logContext = new LogContext();
        Properties p = new Properties();
        p.put("bootstrap.servers", "localhost:9092");
        p.put("key.deserializer", StringSerializer.class.getName());
        p.put("value.deserializer", StringSerializer.class.getName());
        ConsumerConfig config = new ConsumerConfig(p);
        Metrics metrics = ConsumerUtils.createMetrics((ConsumerConfig)config, (Time)this.time);
        this.shareFetchMetricsManager = ConsumerUtils.createShareFetchMetricsManager((Metrics)metrics);
    }

    @Test
    public void testBasicPeekAndPoll() {
        try (ShareFetchBuffer fetchBuffer = new ShareFetchBuffer(this.logContext);){
            ShareCompletedFetch completedFetch = this.completedFetch(this.topicAPartition0);
            Assertions.assertTrue((boolean)fetchBuffer.isEmpty());
            fetchBuffer.add(completedFetch);
            Assertions.assertTrue((boolean)fetchBuffer.hasCompletedFetches(p -> true));
            Assertions.assertFalse((boolean)fetchBuffer.isEmpty());
            Assertions.assertNotNull((Object)fetchBuffer.peek());
            Assertions.assertSame((Object)completedFetch, (Object)fetchBuffer.peek());
            Assertions.assertSame((Object)completedFetch, (Object)fetchBuffer.poll());
            Assertions.assertNull((Object)fetchBuffer.peek());
        }
    }

    @Test
    public void testCloseClearsData() {
        try (ShareFetchBuffer fetchBuffer = null;){
            fetchBuffer = new ShareFetchBuffer(this.logContext);
            Assertions.assertNull((Object)fetchBuffer.nextInLineFetch());
            Assertions.assertTrue((boolean)fetchBuffer.isEmpty());
            fetchBuffer.add(this.completedFetch(this.topicAPartition0));
            Assertions.assertFalse((boolean)fetchBuffer.isEmpty());
            fetchBuffer.setNextInLineFetch(this.completedFetch(this.topicAPartition0));
            Assertions.assertNotNull((Object)fetchBuffer.nextInLineFetch());
        }
        Assertions.assertNull((Object)fetchBuffer.nextInLineFetch());
        Assertions.assertTrue((boolean)fetchBuffer.isEmpty());
    }

    @Test
    public void testBufferedPartitions() {
        try (ShareFetchBuffer fetchBuffer = new ShareFetchBuffer(this.logContext);){
            fetchBuffer.setNextInLineFetch(this.completedFetch(this.topicAPartition0));
            fetchBuffer.add(this.completedFetch(this.topicAPartition1));
            fetchBuffer.add(this.completedFetch(this.topicAPartition2));
            Assertions.assertEquals(this.allPartitions, (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.setNextInLineFetch(null);
            Assertions.assertEquals(ShareFetchBufferTest.partitions(this.topicAPartition1, this.topicAPartition2), (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.poll();
            Assertions.assertEquals(ShareFetchBufferTest.partitions(this.topicAPartition2), (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.poll();
            Assertions.assertEquals(ShareFetchBufferTest.partitions(new TopicIdPartition[0]), (Object)fetchBuffer.bufferedPartitions());
        }
    }

    @Test
    public void testWakeup() throws Exception {
        try (ShareFetchBuffer fetchBuffer = new ShareFetchBuffer(this.logContext);){
            Thread waitingThread = new Thread(() -> {
                Timer timer = this.time.timer(Duration.ofMinutes(1L));
                fetchBuffer.awaitNotEmpty(timer);
            });
            waitingThread.start();
            fetchBuffer.wakeup();
            waitingThread.join(Duration.ofSeconds(30L).toMillis());
            Assertions.assertFalse((boolean)waitingThread.isAlive());
        }
    }

    private ShareCompletedFetch completedFetch(TopicIdPartition tp) {
        ShareFetchMetricsAggregator shareFetchMetricsAggregator = new ShareFetchMetricsAggregator(this.shareFetchMetricsManager, this.allPartitions.stream().map(TopicIdPartition::topicPartition).collect(Collectors.toSet()));
        ShareFetchResponseData.PartitionData partitionData = new ShareFetchResponseData.PartitionData();
        return new ShareCompletedFetch(this.logContext, BufferSupplier.create(), tp, partitionData, shareFetchMetricsAggregator, ApiKeys.SHARE_FETCH.latestVersion());
    }

    private static Set<TopicIdPartition> partitions(TopicIdPartition ... partitions) {
        return new HashSet<TopicIdPartition>(Arrays.asList(partitions));
    }
}

