/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.provider.FileConfigProvider;
import org.junit.jupiter.api.Assertions;

public class MockFileConfigProvider
extends FileConfigProvider {
    private static final Map<String, MockFileConfigProvider> INSTANCES = Collections.synchronizedMap(new HashMap());
    private String id;
    private boolean closed = false;

    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        Object id = configs.get("testId");
        if (id == null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " missing 'testId' config");
        }
        if (this.id != null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " instance was configured twice");
        }
        this.id = id.toString();
        INSTANCES.put(id.toString(), this);
    }

    protected Reader reader(Path path) throws IOException {
        return new StringReader("key=testKey\npassword=randomPassword");
    }

    public synchronized void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertClosed(String id) {
        MockFileConfigProvider instance = INSTANCES.remove(id);
        Assertions.assertNotNull((Object)((Object)instance));
        MockFileConfigProvider mockFileConfigProvider = instance;
        synchronized (mockFileConfigProvider) {
            Assertions.assertTrue((boolean)instance.closed);
        }
    }
}

