/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class DeleteAclsRequestDataJsonConverter {
    public static DeleteAclsRequestData read(JsonNode _node, short _version) {
        DeleteAclsRequestData _object = new DeleteAclsRequestData();
        JsonNode _filtersNode = _node.get("filters");
        if (_filtersNode == null) {
            throw new RuntimeException("DeleteAclsRequestData: unable to locate field 'filters', which is mandatory in version " + _version);
        }
        if (!_filtersNode.isArray()) {
            throw new RuntimeException("DeleteAclsRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<DeleteAclsRequestData.DeleteAclsFilter> _collection = new ArrayList<DeleteAclsRequestData.DeleteAclsFilter>(_filtersNode.size());
        _object.filters = _collection;
        for (JsonNode _element : _filtersNode) {
            _collection.add(DeleteAclsFilterJsonConverter.read(_element, _version));
        }
        JsonNode _clusterIdNode = _node.get("clusterId");
        if (_clusterIdNode == null) {
            _object.clusterId = "";
        } else {
            if (!_clusterIdNode.isTextual()) {
                throw new RuntimeException("DeleteAclsRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.clusterId = _clusterIdNode.asText();
        }
        JsonNode _aclStateNode = _node.get("aclState");
        _object.aclState = _aclStateNode == null ? (byte)3 : MessageUtil.jsonNodeToByte(_aclStateNode, "DeleteAclsRequestData");
        return _object;
    }

    public static JsonNode write(DeleteAclsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _filtersArray = new ArrayNode(JsonNodeFactory.instance);
        for (DeleteAclsRequestData.DeleteAclsFilter _element : _object.filters) {
            _filtersArray.add(DeleteAclsFilterJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("filters", (JsonNode)_filtersArray);
        if (_version >= 2) {
            if (!_object.clusterId.equals("")) {
                _node.set("clusterId", (JsonNode)new TextNode(_object.clusterId));
            }
        } else if (!_object.clusterId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterId at version " + _version);
        }
        if (_version >= 2) {
            if (_object.aclState != 3) {
                _node.set("aclState", (JsonNode)new ShortNode((short)_object.aclState));
            }
        } else if (_object.aclState != 3) {
            throw new UnsupportedVersionException("Attempted to write a non-default aclState at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(DeleteAclsRequestData _object, short _version) {
        return DeleteAclsRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class DeleteAclsFilterJsonConverter {
        public static DeleteAclsRequestData.DeleteAclsFilter read(JsonNode _node, short _version) {
            DeleteAclsRequestData.DeleteAclsFilter _object = new DeleteAclsRequestData.DeleteAclsFilter();
            JsonNode _resourceTypeFilterNode = _node.get("resourceTypeFilter");
            if (_resourceTypeFilterNode == null) {
                throw new RuntimeException("DeleteAclsFilter: unable to locate field 'resourceTypeFilter', which is mandatory in version " + _version);
            }
            _object.resourceTypeFilter = MessageUtil.jsonNodeToByte(_resourceTypeFilterNode, "DeleteAclsFilter");
            JsonNode _resourceNameFilterNode = _node.get("resourceNameFilter");
            if (_resourceNameFilterNode == null) {
                throw new RuntimeException("DeleteAclsFilter: unable to locate field 'resourceNameFilter', which is mandatory in version " + _version);
            }
            if (_resourceNameFilterNode.isNull()) {
                _object.resourceNameFilter = null;
            } else {
                if (!_resourceNameFilterNode.isTextual()) {
                    throw new RuntimeException("DeleteAclsFilter expected a string type, but got " + _node.getNodeType());
                }
                _object.resourceNameFilter = _resourceNameFilterNode.asText();
            }
            JsonNode _patternTypeFilterNode = _node.get("patternTypeFilter");
            if (_patternTypeFilterNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("DeleteAclsFilter: unable to locate field 'patternTypeFilter', which is mandatory in version " + _version);
                }
                _object.patternTypeFilter = (byte)3;
            } else {
                _object.patternTypeFilter = MessageUtil.jsonNodeToByte(_patternTypeFilterNode, "DeleteAclsFilter");
            }
            JsonNode _principalFilterNode = _node.get("principalFilter");
            if (_principalFilterNode == null) {
                throw new RuntimeException("DeleteAclsFilter: unable to locate field 'principalFilter', which is mandatory in version " + _version);
            }
            if (_principalFilterNode.isNull()) {
                _object.principalFilter = null;
            } else {
                if (!_principalFilterNode.isTextual()) {
                    throw new RuntimeException("DeleteAclsFilter expected a string type, but got " + _node.getNodeType());
                }
                _object.principalFilter = _principalFilterNode.asText();
            }
            JsonNode _hostFilterNode = _node.get("hostFilter");
            if (_hostFilterNode == null) {
                throw new RuntimeException("DeleteAclsFilter: unable to locate field 'hostFilter', which is mandatory in version " + _version);
            }
            if (_hostFilterNode.isNull()) {
                _object.hostFilter = null;
            } else {
                if (!_hostFilterNode.isTextual()) {
                    throw new RuntimeException("DeleteAclsFilter expected a string type, but got " + _node.getNodeType());
                }
                _object.hostFilter = _hostFilterNode.asText();
            }
            JsonNode _operationNode = _node.get("operation");
            if (_operationNode == null) {
                throw new RuntimeException("DeleteAclsFilter: unable to locate field 'operation', which is mandatory in version " + _version);
            }
            _object.operation = MessageUtil.jsonNodeToByte(_operationNode, "DeleteAclsFilter");
            JsonNode _permissionTypeNode = _node.get("permissionType");
            if (_permissionTypeNode == null) {
                throw new RuntimeException("DeleteAclsFilter: unable to locate field 'permissionType', which is mandatory in version " + _version);
            }
            _object.permissionType = MessageUtil.jsonNodeToByte(_permissionTypeNode, "DeleteAclsFilter");
            JsonNode _clusterLinkIdsNode = _node.get("clusterLinkIds");
            if (_clusterLinkIdsNode == null) {
                _object.clusterLinkIds = new ArrayList<Uuid>(0);
            } else {
                if (!_clusterLinkIdsNode.isArray()) {
                    throw new RuntimeException("DeleteAclsFilter expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Uuid> _collection = new ArrayList<Uuid>(_clusterLinkIdsNode.size());
                _object.clusterLinkIds = _collection;
                for (JsonNode _element : _clusterLinkIdsNode) {
                    if (!_element.isTextual()) {
                        throw new RuntimeException("DeleteAclsFilter element expected a JSON string type, but got " + _node.getNodeType());
                    }
                    _collection.add(Uuid.fromString(_element.asText()));
                }
            }
            return _object;
        }

        public static JsonNode write(DeleteAclsRequestData.DeleteAclsFilter _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("resourceTypeFilter", (JsonNode)new ShortNode((short)_object.resourceTypeFilter));
            if (_object.resourceNameFilter == null) {
                _node.set("resourceNameFilter", (JsonNode)NullNode.instance);
            } else {
                _node.set("resourceNameFilter", (JsonNode)new TextNode(_object.resourceNameFilter));
            }
            if (_version >= 1) {
                _node.set("patternTypeFilter", (JsonNode)new ShortNode((short)_object.patternTypeFilter));
            } else if (_object.patternTypeFilter != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + _version);
            }
            if (_object.principalFilter == null) {
                _node.set("principalFilter", (JsonNode)NullNode.instance);
            } else {
                _node.set("principalFilter", (JsonNode)new TextNode(_object.principalFilter));
            }
            if (_object.hostFilter == null) {
                _node.set("hostFilter", (JsonNode)NullNode.instance);
            } else {
                _node.set("hostFilter", (JsonNode)new TextNode(_object.hostFilter));
            }
            _node.set("operation", (JsonNode)new ShortNode((short)_object.operation));
            _node.set("permissionType", (JsonNode)new ShortNode((short)_object.permissionType));
            if (_version >= 2 && !_object.clusterLinkIds.isEmpty()) {
                ArrayNode _clusterLinkIdsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Uuid _element : _object.clusterLinkIds) {
                    _clusterLinkIdsArray.add((JsonNode)new TextNode(_element.toString()));
                }
                _node.set("clusterLinkIds", (JsonNode)_clusterLinkIdsArray);
            }
            return _node;
        }

        public static JsonNode write(DeleteAclsRequestData.DeleteAclsFilter _object, short _version) {
            return DeleteAclsFilterJsonConverter.write(_object, _version, true);
        }
    }
}

