/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;

public class ConfigurationUtils {
    private final Map<String, ?> configs;
    private final String prefix;

    public ConfigurationUtils(Map<String, ?> configs) {
        this(configs, null);
    }

    public ConfigurationUtils(Map<String, ?> configs, String saslMechanism) {
        this.configs = configs;
        this.prefix = saslMechanism != null && !saslMechanism.trim().isEmpty() ? ListenerName.saslMechanismPrefix(saslMechanism.trim()) : null;
    }

    public Path validateFile(String name) {
        File file;
        URL url = this.validateUrl(name);
        try {
            file = new File(url.toURI().getRawPath()).getAbsoluteFile();
        }
        catch (URISyntaxException e) {
            throw new ConfigException(name, url.toString(), String.format("The OAuth configuration option %s contains a URL (%s) that is malformed: %s", name, url, e.getMessage()));
        }
        if (!file.exists()) {
            throw new ConfigException(name, file, String.format("The OAuth configuration option %s contains a file (%s) that doesn't exist", name, file));
        }
        if (!file.canRead()) {
            throw new ConfigException(name, file, String.format("The OAuth configuration option %s contains a file (%s) that doesn't have read permission", name, file));
        }
        if (file.isDirectory()) {
            throw new ConfigException(name, file, String.format("The OAuth configuration option %s references a directory (%s), not a file", name, file));
        }
        return file.toPath();
    }

    public Integer validateInteger(String name, boolean isRequired) {
        Integer value = (Integer)this.get(name);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(name, null, String.format("The OAuth configuration option %s must be non-null", name));
            }
            return null;
        }
        return value;
    }

    public Long validateLong(String name) {
        return this.validateLong(name, true);
    }

    public Long validateLong(String name, boolean isRequired) {
        return this.validateLong(name, isRequired, null);
    }

    public Long validateLong(String name, boolean isRequired, Long min) {
        Long value = (Long)this.get(name);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(name, null, String.format("The OAuth configuration option %s must be non-null", name));
            }
            return null;
        }
        if (min != null && value < min) {
            throw new ConfigException(name, value, String.format("The OAuth configuration option %s value must be at least %s", name, min));
        }
        return value;
    }

    public URL validateUrl(String name) {
        URL url;
        String value = this.validateString(name);
        try {
            url = new URL(value);
        }
        catch (MalformedURLException e) {
            throw new ConfigException(name, value, String.format("The OAuth configuration option %s contains a URL (%s) that is malformed: %s", name, value, e.getMessage()));
        }
        String protocol = url.getProtocol();
        if (protocol == null || protocol.trim().isEmpty()) {
            throw new ConfigException(name, value, String.format("The OAuth configuration option %s contains a URL (%s) that is missing the protocol", name, value));
        }
        if (!((protocol = protocol.toLowerCase(Locale.ROOT)).equals("http") || protocol.equals("https") || protocol.equals("file"))) {
            throw new ConfigException(name, value, String.format("The OAuth configuration option %s contains a URL (%s) that contains an invalid protocol (%s); only \"http\", \"https\", and \"file\" protocol are supported", name, value, protocol));
        }
        return url;
    }

    public String validateString(String name) throws ValidateException {
        return this.validateString(name, true);
    }

    public String validateString(String name, boolean isRequired) throws ValidateException {
        String value = (String)this.get(name);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s value must be non-null", name));
            }
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s value must not contain only whitespace", name));
            }
            return null;
        }
        return value;
    }

    public <T> T get(String name) {
        Object value = this.configs.get(this.prefix + name);
        if (value != null) {
            return (T)value;
        }
        return (T)this.configs.get(name);
    }

    public void throwIfURLIsNotAllowed(String urlConfig) {
        String value;
        String allowedUrlsProp = System.getProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
        if (allowedUrlsProp == null) {
            return;
        }
        Set allowedUrlsList = Arrays.stream(allowedUrlsProp.split(",")).map(String::trim).collect(Collectors.toSet());
        if (!allowedUrlsList.contains(value = (String)this.get(urlConfig))) {
            throw new IllegalArgumentException(value + " is not allowed. Update system property '" + "org.apache.kafka.sasl.oauthbearer.allowed.urls" + "' to allow " + value);
        }
    }
}

