/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.http;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public final class MetadataServerConfig
extends AbstractConfig {
    public static final String HTTP_SERVER_PREFIX = "confluent.http.server.";
    public static final String METADATA_SERVER_PREFIX = "confluent.metadata.server.";
    public static final String METADATA_SERVER_LISTENERS_PROP = "confluent.metadata.server.listeners";
    private static final String METADATA_SERVER_LISTENERS_DEFAULT = null;
    private static final String METADATA_SERVER_LISTENERS_DOC = "DEPRECATED: See `confluent.http.server.listeners` for current usage.Comma-separated list of listener URLs for metadata server to listener on if this broker hosts an embedded Metadata Server plugin for centralized management of metadata for theConfluent Platform. Specify hostname as 0.0.0.0 to bind to all interfaces. Examples of valid listeners are https://0.0.0.0:8090,http://127.0.0.1:8091.Centralized metadata management server is not enabled by default.";
    public static final String METADATA_SERVER_ADVERTISED_LISTENERS_PROP = "confluent.metadata.server.advertised.listeners";
    private static final String METADATA_SERVER_ADVERTISED_LISTENERS_DEFAULT = null;
    private static final String METADATA_SERVER_ADVERTISED_LISTENERS_DOC = "Comma-separated list of advertised listener URLs of metadata server if this broker hosts anembedded metadata server plugin. Metadata server URLs must be unique across the cluster since they are used as node ids for master writer election. The URLs are also used for redirection of update requests to the master writer. If not specified, 'confluent.metadata.server.listeners' config will be used. 0.0.0.0 may not be used as the host name in advertised listeners.";
    public static final String HTTP_SERVER_LISTENERS_PROP = "confluent.http.server.listeners";
    public static final String HTTP_SERVER_LISTENERS_DEFAULT = "http://0.0.0.0:8090";
    private static final String HTTP_SERVER_LISTENERS_DOC = "Comma-separated list of listener URLs for HTTP server to listener on if this broker hosts an embedded HTTP server plugin for metadata related to the local cluster. Specify hostname as 0.0.0.0 to bind to all interfaces. Examples of valid listeners are https://0.0.0.0:8090,http://127.0.0.1:8091. The default value is http://0.0.0.0:8090. Configure 'confluent.metadata.server.listeners' if this broker hosts Metadata Service  for centralized metadata management.";
    public static final String ENABLE_MDS_PROP = "confluent.metadata.server.enable";
    public static final boolean ENABLE_MDS_DEFAULT = false;
    private static final String ENABLE_MDS_DOC = "Set to true when using `confluent.http.server.listeners` to enable MDS on this broker.";
    private static final ConfigDef CONFIG = new ConfigDef().define("confluent.metadata.server.enable", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, "Set to true when using `confluent.http.server.listeners` to enable MDS on this broker.").define("confluent.metadata.server.listeners", ConfigDef.Type.LIST, METADATA_SERVER_LISTENERS_DEFAULT, ConfigDef.Importance.HIGH, "DEPRECATED: See `confluent.http.server.listeners` for current usage.Comma-separated list of listener URLs for metadata server to listener on if this broker hosts an embedded Metadata Server plugin for centralized management of metadata for theConfluent Platform. Specify hostname as 0.0.0.0 to bind to all interfaces. Examples of valid listeners are https://0.0.0.0:8090,http://127.0.0.1:8091.Centralized metadata management server is not enabled by default.").define("confluent.metadata.server.advertised.listeners", ConfigDef.Type.LIST, METADATA_SERVER_ADVERTISED_LISTENERS_DEFAULT, ConfigDef.Importance.HIGH, "Comma-separated list of advertised listener URLs of metadata server if this broker hosts anembedded metadata server plugin. Metadata server URLs must be unique across the cluster since they are used as node ids for master writer election. The URLs are also used for redirection of update requests to the master writer. If not specified, 'confluent.metadata.server.listeners' config will be used. 0.0.0.0 may not be used as the host name in advertised listeners.").define("confluent.http.server.listeners", ConfigDef.Type.LIST, "http://0.0.0.0:8090", ConfigDef.Importance.HIGH, "Comma-separated list of listener URLs for HTTP server to listener on if this broker hosts an embedded HTTP server plugin for metadata related to the local cluster. Specify hostname as 0.0.0.0 to bind to all interfaces. Examples of valid listeners are https://0.0.0.0:8090,http://127.0.0.1:8091. The default value is http://0.0.0.0:8090. Configure 'confluent.metadata.server.listeners' if this broker hosts Metadata Service  for centralized metadata management.");
    private boolean metadataServerEnabled;
    private final List<URL> listeners;
    private final List<URL> metadataServerAdvertisedListeners;

    public MetadataServerConfig(Map<?, ?> props) {
        super(CONFIG, props);
        List<URL> metadataServerListeners = MetadataServerConfig.toUrls(this.getListenersList(METADATA_SERVER_LISTENERS_PROP, HTTP_SERVER_LISTENERS_PROP, this.getBoolean(ENABLE_MDS_PROP)));
        if (metadataServerListeners.isEmpty()) {
            this.metadataServerEnabled = false;
            this.listeners = Collections.unmodifiableList(MetadataServerConfig.toUrls(this.getList(HTTP_SERVER_LISTENERS_PROP)));
            this.metadataServerAdvertisedListeners = Collections.emptyList();
        } else {
            this.metadataServerEnabled = true;
            this.listeners = Collections.unmodifiableList(metadataServerListeners);
            this.metadataServerAdvertisedListeners = props.containsKey(METADATA_SERVER_ADVERTISED_LISTENERS_PROP) ? MetadataServerConfig.toUrls(this.getList(METADATA_SERVER_ADVERTISED_LISTENERS_PROP)) : metadataServerListeners;
            MetadataServerConfig.checkUniqueProtocols(this.metadataServerAdvertisedListeners);
            if (!this.metadataServerAdvertisedListeners.isEmpty()) {
                MetadataServerConfig.checkSameProtocols(metadataServerListeners, this.metadataServerAdvertisedListeners);
            }
        }
        MetadataServerConfig.checkUniqueProtocols(this.listeners);
    }

    public boolean isServerEnabled() {
        return !this.listeners.isEmpty();
    }

    private List<String> getListenersList(String key, String alias, boolean enableMds) {
        List<String> valueList = this.getList(key);
        return valueList == null && enableMds ? this.getList(alias) : valueList;
    }

    public boolean isConfluentMetadataServerEnabled() {
        return this.metadataServerEnabled;
    }

    public static boolean isConfluentMetadataServerEnabledOnConfig(Map<Object, Object> props) {
        String metadataServerListeners = props.getOrDefault(METADATA_SERVER_LISTENERS_PROP, "").toString();
        boolean hasMetadataServerListeners = !metadataServerListeners.isEmpty();
        boolean enableMds = "true".equals(props.getOrDefault(ENABLE_MDS_PROP, false).toString());
        String mdsListenersToUse = hasMetadataServerListeners || !enableMds ? metadataServerListeners : props.getOrDefault(HTTP_SERVER_LISTENERS_PROP, HTTP_SERVER_LISTENERS_DEFAULT).toString();
        return !mdsListenersToUse.isEmpty();
    }

    public List<URL> listeners() {
        return this.listeners;
    }

    public List<URL> metadataServerAdvertisedListeners() {
        return this.metadataServerAdvertisedListeners;
    }

    public Map<String, Object> serverConfigs() {
        Object schemaRegistryUrls;
        Map<String, Object> originals;
        Object accessRuleProviders;
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.putAll(this.originalsWithPrefix(HTTP_SERVER_PREFIX));
        if (this.isConfluentMetadataServerEnabled()) {
            configs.putAll(this.originalsWithPrefix(METADATA_SERVER_PREFIX));
            configs.put("advertised.listeners", Utils.join(this.metadataServerAdvertisedListeners, ","));
            configs.put(HTTP_SERVER_LISTENERS_PROP, Utils.join(this.listeners, ","));
        }
        if (this.isServerEnabled()) {
            configs.put("listeners", Utils.join(this.listeners, ","));
        }
        if ((accessRuleProviders = (originals = this.originals()).get("confluent.authorizer.access.rule.providers")) != null) {
            configs.put("confluent.authorizer.access.rule.providers", accessRuleProviders);
        }
        if ((schemaRegistryUrls = originals.get("confluent.schema.registry.url")) != null) {
            configs.put("confluent.schema.registry.url", schemaRegistryUrls);
        }
        return configs;
    }

    public String toString() {
        return Utils.mkString(this.values(), "", "", "=", "%n\t");
    }

    private static List<URL> toUrls(List<String> specs) {
        if (specs == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String spec : specs) {
            try {
                urls.add(new URL(spec));
            }
            catch (MalformedURLException e) {
                throw new ConfigException(String.format("Invalid URL: %s", spec), (Object)e);
            }
        }
        return urls;
    }

    private static void checkUniqueProtocols(List<URL> urls) {
        if (MetadataServerConfig.getProtocols(urls).size() != urls.size()) {
            throw new ConfigException(String.format("Multiple URLs specified for the same protocol: %s", urls));
        }
    }

    private static void checkSameProtocols(List<URL> left, List<URL> right) {
        if (!MetadataServerConfig.getProtocols(left).equals(MetadataServerConfig.getProtocols(right))) {
            throw new ConfigException(String.format("URLs protocols don't match: %s, %s", left, right));
        }
    }

    private static Set<String> getProtocols(List<URL> urls) {
        return urls.stream().map(URL::getProtocol).collect(Collectors.toSet());
    }

    public static void main(String[] args) throws Exception {
        try (PrintStream out = args.length == 0 ? System.out : new PrintStream((OutputStream)new FileOutputStream(args[0]), false, StandardCharsets.UTF_8.name());){
            out.println(CONFIG.toHtmlTable());
            if (out != System.out) {
                out.close();
            }
        }
    }
}

