/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenMock;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredLoginCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredValidatorCallbackHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OAuthBearerSaslServerTest {
    private static final String USER = "user";
    private static final Map<String, ?> CONFIGS;
    private static final AuthenticateCallbackHandler LOGIN_CALLBACK_HANDLER;
    private static final AuthenticateCallbackHandler VALIDATOR_CALLBACK_HANDLER;
    private static final AuthenticateCallbackHandler EXTENSIONS_VALIDATOR_CALLBACK_HANDLER;
    private OAuthBearerSaslServer saslServer;

    @BeforeEach
    public void setUp() {
        this.saslServer = new OAuthBearerSaslServer((CallbackHandler)VALIDATOR_CALLBACK_HANDLER);
    }

    @Test
    public void noAuthorizationIdSpecified() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(null));
        Assertions.assertTrue((nextChallenge.length == 0 ? 1 : 0) != 0, (String)"Next challenge is not empty");
    }

    @Test
    public void negotiatedProperty() throws Exception {
        this.saslServer.evaluateResponse(this.clientInitialResponse(USER));
        OAuthBearerToken token = (OAuthBearerToken)this.saslServer.getNegotiatedProperty("OAUTHBEARER.token");
        Assertions.assertNotNull((Object)token);
        Assertions.assertEquals((Object)token.lifetimeMs(), (Object)this.saslServer.getNegotiatedProperty("CREDENTIAL.LIFETIME.MS"));
    }

    @Test
    public void savesCustomExtensionAsNegotiatedProperty() throws Exception {
        HashMap<String, String> customExtensions = new HashMap<String, String>();
        customExtensions.put("firstKey", "value1");
        customExtensions.put("secondKey", "value2");
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(null, false, customExtensions));
        Assertions.assertTrue((nextChallenge.length == 0 ? 1 : 0) != 0, (String)"Next challenge is not empty");
        Assertions.assertEquals((Object)"value1", (Object)this.saslServer.getNegotiatedProperty("firstKey"));
        Assertions.assertEquals((Object)"value2", (Object)this.saslServer.getNegotiatedProperty("secondKey"));
    }

    @Test
    public void unrecognizedExtensionsAreNotSaved() throws Exception {
        this.saslServer = new OAuthBearerSaslServer((CallbackHandler)EXTENSIONS_VALIDATOR_CALLBACK_HANDLER);
        HashMap<String, String> customExtensions = new HashMap<String, String>();
        customExtensions.put("firstKey", "value1");
        customExtensions.put("secondKey", "value1");
        customExtensions.put("thirdKey", "value1");
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(null, false, customExtensions));
        Assertions.assertTrue((nextChallenge.length == 0 ? 1 : 0) != 0, (String)"Next challenge is not empty");
        Assertions.assertNull((Object)this.saslServer.getNegotiatedProperty("thirdKey"), (String)"Extensions not recognized by the server must be ignored");
    }

    @Test
    public void throwsAuthenticationExceptionOnInvalidExtensions() {
        OAuthBearerUnsecuredValidatorCallbackHandler invalidHandler = new OAuthBearerUnsecuredValidatorCallbackHandler(){

            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof OAuthBearerValidatorCallback) {
                        OAuthBearerValidatorCallback validationCallback = (OAuthBearerValidatorCallback)callback;
                        validationCallback.token((OAuthBearerToken)new OAuthBearerTokenMock());
                        continue;
                    }
                    if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                        OAuthBearerExtensionsValidatorCallback extensionsCallback = (OAuthBearerExtensionsValidatorCallback)callback;
                        extensionsCallback.error("firstKey", "is not valid");
                        extensionsCallback.error("secondKey", "is not valid either");
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        this.saslServer = new OAuthBearerSaslServer((CallbackHandler)invalidHandler);
        HashMap<String, String> customExtensions = new HashMap<String, String>();
        customExtensions.put("firstKey", "value");
        customExtensions.put("secondKey", "value");
        Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.clientInitialResponse(null, false, customExtensions)));
    }

    @Test
    public void authorizatonIdEqualsAuthenticationId() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(USER));
        Assertions.assertTrue((nextChallenge.length == 0 ? 1 : 0) != 0, (String)"Next challenge is not empty");
    }

    @Test
    public void authorizatonIdNotEqualsAuthenticationId() {
        Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.clientInitialResponse("userx")));
    }

    @Test
    public void illegalToken() throws Exception {
        byte[] bytes = this.saslServer.evaluateResponse(this.clientInitialResponse(null, true, Collections.emptyMap()));
        String challenge = new String(bytes, StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"{\"status\":\"invalid_token\"}", (Object)challenge);
    }

    private byte[] clientInitialResponse(String authorizationId) throws OAuthBearerConfigException, IOException, UnsupportedCallbackException, LoginException {
        return this.clientInitialResponse(authorizationId, false);
    }

    private byte[] clientInitialResponse(String authorizationId, boolean illegalToken) throws OAuthBearerConfigException, IOException, UnsupportedCallbackException {
        return this.clientInitialResponse(authorizationId, false, Collections.emptyMap());
    }

    private byte[] clientInitialResponse(String authorizationId, boolean illegalToken, Map<String, String> customExtensions) throws OAuthBearerConfigException, IOException, UnsupportedCallbackException {
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        LOGIN_CALLBACK_HANDLER.handle(new Callback[]{callback});
        OAuthBearerToken token = callback.token();
        String compactSerialization = token.value();
        String tokenValue = compactSerialization + (illegalToken ? "AB" : "");
        return new OAuthBearerClientInitialResponse(tokenValue, authorizationId, new SaslExtensions(customExtensions)).toBytes();
    }

    static {
        String jaasConfigText = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required unsecuredLoginStringClaim_sub=\"user\";";
        HashMap<String, Password> tmp = new HashMap<String, Password>();
        tmp.put("sasl.jaas.config", new Password(jaasConfigText));
        CONFIGS = Collections.unmodifiableMap(tmp);
        LOGIN_CALLBACK_HANDLER = new OAuthBearerUnsecuredLoginCallbackHandler();
        LOGIN_CALLBACK_HANDLER.configure(CONFIGS, "OAUTHBEARER", JaasContext.loadClientContext(CONFIGS).configurationEntries());
        VALIDATOR_CALLBACK_HANDLER = new OAuthBearerUnsecuredValidatorCallbackHandler();
        VALIDATOR_CALLBACK_HANDLER.configure(CONFIGS, "OAUTHBEARER", JaasContext.loadClientContext(CONFIGS).configurationEntries());
        EXTENSIONS_VALIDATOR_CALLBACK_HANDLER = new OAuthBearerUnsecuredValidatorCallbackHandler(){

            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof OAuthBearerValidatorCallback) {
                        OAuthBearerValidatorCallback validationCallback = (OAuthBearerValidatorCallback)callback;
                        validationCallback.token((OAuthBearerToken)new OAuthBearerTokenMock());
                        continue;
                    }
                    if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                        OAuthBearerExtensionsValidatorCallback extensionsCallback = (OAuthBearerExtensionsValidatorCallback)callback;
                        extensionsCallback.valid("firstKey");
                        extensionsCallback.valid("secondKey");
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
    }
}

