/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class BrokerHeartbeatResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    boolean isCaughtUp;
    boolean isFenced;
    boolean shouldShutDown;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no error."), new Field("is_caught_up", (Type)Type.BOOLEAN, "True if the broker has approximately caught up with the latest metadata."), new Field("is_fenced", (Type)Type.BOOLEAN, "True if the broker is fenced."), new Field("should_shut_down", (Type)Type.BOOLEAN, "True if the broker should proceed with its shutdown."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public BrokerHeartbeatResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public BrokerHeartbeatResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.isCaughtUp = false;
        this.isFenced = true;
        this.shouldShutDown = false;
    }

    public short apiKey() {
        return 63;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        this.isCaughtUp = _readable.readByte() != 0;
        this.isFenced = _readable.readByte() != 0;
        this.shouldShutDown = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeByte(this.isCaughtUp ? (byte)1 : 0);
        _writable.writeByte(this.isFenced ? (byte)1 : 0);
        _writable.writeByte(this.shouldShutDown ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        _size.addBytes(1);
        _size.addBytes(1);
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrokerHeartbeatResponseData)) {
            return false;
        }
        BrokerHeartbeatResponseData other = (BrokerHeartbeatResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.isCaughtUp != other.isCaughtUp) {
            return false;
        }
        if (this.isFenced != other.isFenced) {
            return false;
        }
        if (this.shouldShutDown != other.shouldShutDown) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.isCaughtUp ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.isFenced ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.shouldShutDown ? 1231 : 1237);
        return hashCode;
    }

    public BrokerHeartbeatResponseData duplicate() {
        BrokerHeartbeatResponseData _duplicate = new BrokerHeartbeatResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.isCaughtUp = this.isCaughtUp;
        _duplicate.isFenced = this.isFenced;
        _duplicate.shouldShutDown = this.shouldShutDown;
        return _duplicate;
    }

    public String toString() {
        return "BrokerHeartbeatResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", isCaughtUp=" + (this.isCaughtUp ? "true" : "false") + ", isFenced=" + (this.isFenced ? "true" : "false") + ", shouldShutDown=" + (this.shouldShutDown ? "true" : "false") + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public boolean isCaughtUp() {
        return this.isCaughtUp;
    }

    public boolean isFenced() {
        return this.isFenced;
    }

    public boolean shouldShutDown() {
        return this.shouldShutDown;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BrokerHeartbeatResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public BrokerHeartbeatResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public BrokerHeartbeatResponseData setIsCaughtUp(boolean v) {
        this.isCaughtUp = v;
        return this;
    }

    public BrokerHeartbeatResponseData setIsFenced(boolean v) {
        this.isFenced = v;
        return this;
    }

    public BrokerHeartbeatResponseData setShouldShutDown(boolean v) {
        this.shouldShutDown = v;
        return this;
    }
}

