/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignorTest;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CooperativeStickyAssignorTest
extends AbstractStickyAssignorTest {
    @Override
    public AbstractStickyAssignor createAssignor() {
        return new CooperativeStickyAssignor();
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscription(List<String> topics, List<TopicPartition> partitions) {
        return new ConsumerPartitionAssignor.Subscription(topics, this.assignor.subscriptionUserData(new HashSet<String>(topics)), partitions);
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionWithGeneration(List<String> topics, List<TopicPartition> partitions, int generation) {
        this.assignor.onAssignment(null, new ConsumerGroupMetadata("dummy-group-id", generation, "dummy-member-id", Optional.empty()));
        return new ConsumerPartitionAssignor.Subscription(topics, this.assignor.subscriptionUserData(new HashSet<String>(topics)), partitions);
    }

    @Test
    public void testEncodeAndDecodeGeneration() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(CooperativeStickyAssignorTest.topics(this.topic), this.assignor.subscriptionUserData(new HashSet<String>(CooperativeStickyAssignorTest.topics(this.topic))));
        Optional encodedGeneration = ((CooperativeStickyAssignor)this.assignor).memberData((ConsumerPartitionAssignor.Subscription)subscription).generation;
        Assertions.assertTrue((boolean)encodedGeneration.isPresent());
        Assertions.assertEquals((Integer)((Integer)encodedGeneration.get()), (int)-1);
        int generation = 10;
        this.assignor.onAssignment(null, new ConsumerGroupMetadata("dummy-group-id", generation, "dummy-member-id", Optional.empty()));
        subscription = new ConsumerPartitionAssignor.Subscription(CooperativeStickyAssignorTest.topics(this.topic), this.assignor.subscriptionUserData(new HashSet<String>(CooperativeStickyAssignorTest.topics(this.topic))));
        encodedGeneration = ((CooperativeStickyAssignor)this.assignor).memberData((ConsumerPartitionAssignor.Subscription)subscription).generation;
        Assertions.assertTrue((boolean)encodedGeneration.isPresent());
        Assertions.assertEquals((Integer)((Integer)encodedGeneration.get()), (int)generation);
    }

    @Test
    public void testDecodeGeneration() {
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(CooperativeStickyAssignorTest.topics(this.topic));
        Assertions.assertFalse((boolean)((CooperativeStickyAssignor)this.assignor).memberData((ConsumerPartitionAssignor.Subscription)subscription).generation.isPresent());
    }

    @Test
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithEqualPartitionsPerConsumer() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(this.consumer1, this.buildSubscription(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 1))));
        this.subscriptions.put(this.consumer2, this.buildSubscription(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 2))));
        this.subscriptions.put(this.consumer3, this.buildSubscription(CooperativeStickyAssignorTest.topics(this.topic), Collections.emptyList()));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumer3)).isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)CooperativeStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithUnequalPartitionsPerConsumer() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 4);
        this.subscriptions.put(this.consumer1, this.buildSubscription(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 1))));
        this.subscriptions.put(this.consumer2, this.buildSubscription(CooperativeStickyAssignorTest.topics(this.topic), CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 0), CooperativeStickyAssignorTest.tp(this.topic, 2))));
        this.subscriptions.put(this.consumer3, this.buildSubscription(CooperativeStickyAssignorTest.topics(this.topic), Collections.emptyList()));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(CooperativeStickyAssignorTest.partitions(CooperativeStickyAssignorTest.tp(this.topic, 2), CooperativeStickyAssignorTest.tp(this.topic, 3)), assignment.get(this.consumer2));
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumer3)).isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)CooperativeStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Override
    public void verifyValidityAndBalance(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments, Map<String, Integer> partitionsPerTopic) {
        int rebalances = 0;
        while (this.verifyCooperativeValidity(subscriptions, assignments)) {
            for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
                String consumer = entry.getKey();
                ConsumerPartitionAssignor.Subscription oldSubscription = subscriptions.get(consumer);
                subscriptions.put(consumer, this.buildSubscription(oldSubscription.topics(), entry.getValue()));
            }
            assignments.clear();
            assignments.putAll(this.assignor.assign(partitionsPerTopic, subscriptions));
            Assertions.assertTrue((++rebalances <= 4 ? 1 : 0) != 0);
        }
        super.verifyValidityAndBalance(subscriptions, assignments, partitionsPerTopic);
    }

    private boolean verifyCooperativeValidity(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments) {
        HashSet<TopicPartition> allAddedPartitions = new HashSet<TopicPartition>();
        HashSet allRevokedPartitions = new HashSet();
        for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
            List ownedPartitions = subscriptions.get(entry.getKey()).ownedPartitions();
            List<TopicPartition> assignedPartitions = entry.getValue();
            HashSet revokedPartitions = new HashSet(ownedPartitions);
            revokedPartitions.removeAll(assignedPartitions);
            HashSet<TopicPartition> addedPartitions = new HashSet<TopicPartition>(assignedPartitions);
            addedPartitions.removeAll(ownedPartitions);
            allAddedPartitions.addAll(addedPartitions);
            allRevokedPartitions.addAll(revokedPartitions);
        }
        HashSet intersection = new HashSet(allAddedPartitions);
        intersection.retainAll(allRevokedPartitions);
        Assertions.assertTrue((boolean)intersection.isEmpty(), (String)("Error: Some partitions were assigned to a new consumer during the same rebalance they are being revoked from their previous owner. Partitions: " + intersection));
        return !allRevokedPartitions.isEmpty();
    }
}

