/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SaslAuthenticateResponseData
implements ApiMessage {
    private short errorCode;
    private String errorMessage;
    private byte[] authBytes;
    private long sessionLifetimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("auth_bytes", Type.BYTES, "The SASL authentication bytes from the server, as defined by the SASL mechanism."));
    public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("auth_bytes", Type.BYTES, "The SASL authentication bytes from the server, as defined by the SASL mechanism."), new Field("session_lifetime_ms", Type.INT64, "The SASL authentication bytes from the server, as defined by the SASL mechanism."));
    public static final Schema SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("auth_bytes", Type.COMPACT_BYTES, "The SASL authentication bytes from the server, as defined by the SASL mechanism."), new Field("session_lifetime_ms", Type.INT64, "The SASL authentication bytes from the server, as defined by the SASL mechanism."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

    public SaslAuthenticateResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SaslAuthenticateResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public SaslAuthenticateResponseData() {
        this.errorCode = 0;
        this.errorMessage = "";
        this.authBytes = Bytes.EMPTY;
        this.sessionLifetimeMs = 0L;
    }

    @Override
    public short apiKey() {
        return 36;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
        if (length < 0) {
            throw new RuntimeException("non-nullable field authBytes was serialized as null");
        }
        byte[] newBytes = _readable.readArray(length);
        this.authBytes = newBytes;
        this.sessionLifetimeMs = _version >= 1 ? _readable.readLong() : 0L;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            if (_version >= 2) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.authBytes.length + 1);
        } else {
            _writable.writeInt(this.authBytes.length);
        }
        _writable.writeByteArray(this.authBytes);
        if (_version >= 1) {
            _writable.writeLong(this.sessionLifetimeMs);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        this.authBytes = struct.getByteArray("auth_bytes");
        this.sessionLifetimeMs = _version >= 1 ? struct.getLong("session_lifetime_ms") : 0L;
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        struct.setByteArray("auth_bytes", this.authBytes);
        if (_version >= 1) {
            struct.set("session_lifetime_ms", (Object)this.sessionLifetimeMs);
        }
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        if (this.errorMessage == null) {
            _size = _version >= 2 ? ++_size : (_size += 2);
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        }
        int _bytesSize = this.authBytes.length;
        _bytesSize = _version >= 2 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint(this.authBytes.length + 1)) : (_bytesSize += 4);
        _size += _bytesSize;
        if (_version >= 1) {
            _size += 8;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SaslAuthenticateResponseData)) {
            return false;
        }
        SaslAuthenticateResponseData other = (SaslAuthenticateResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (!Arrays.equals(this.authBytes, other.authBytes)) {
            return false;
        }
        return this.sessionLifetimeMs == other.sessionLifetimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.authBytes);
        hashCode = 31 * hashCode + ((int)(this.sessionLifetimeMs >> 32) ^ (int)this.sessionLifetimeMs);
        return hashCode;
    }

    public String toString() {
        return "SaslAuthenticateResponseData(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", authBytes=" + Arrays.toString(this.authBytes) + ", sessionLifetimeMs=" + this.sessionLifetimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public byte[] authBytes() {
        return this.authBytes;
    }

    public long sessionLifetimeMs() {
        return this.sessionLifetimeMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SaslAuthenticateResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public SaslAuthenticateResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public SaslAuthenticateResponseData setAuthBytes(byte[] v) {
        this.authBytes = v;
        return this;
    }

    public SaslAuthenticateResponseData setSessionLifetimeMs(long v) {
        this.sessionLifetimeMs = v;
        return this;
    }
}

