/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListOffsetResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<ListOffsetTopicResponse> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(ListOffsetTopicResponse.SCHEMA_0), "Each topic in the response."));
    public static final Schema SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(ListOffsetTopicResponse.SCHEMA_1), "Each topic in the response."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public ListOffsetResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ListOffsetResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public ListOffsetResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<ListOffsetTopicResponse>();
    }

    @Override
    public short apiKey() {
        return 2;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<ListOffsetTopicResponse> newCollection = new ArrayList<ListOffsetTopicResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ListOffsetTopicResponse(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeInt(this.topics.size());
        for (ListOffsetTopicResponse topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = _version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<ListOffsetTopicResponse>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new ListOffsetTopicResponse((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (ListOffsetTopicResponse element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (ListOffsetTopicResponse topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListOffsetResponseData)) {
            return false;
        }
        ListOffsetResponseData other = (ListOffsetResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ListOffsetResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<ListOffsetTopicResponse> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListOffsetResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ListOffsetResponseData setTopics(List<ListOffsetTopicResponse> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(ListOffsetTopicResponse.SCHEMA_1), "Each topic in the response."));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(ListOffsetTopicResponse.SCHEMA_4), "Each topic in the response."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class ListOffsetPartitionResponse
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private List<Long> oldStyleOffsets;
        private long timestamp;
        private long offset;
        private int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), new Field("old_style_offsets", new ArrayOf(Type.INT64), "The result offsets."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetPartitionResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetPartitionResponse(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public ListOffsetPartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.oldStyleOffsets = new ArrayList<Long>();
            this.timestamp = -1L;
            this.offset = -1L;
            this.leaderEpoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartitionResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            if (_version <= 0) {
                int arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field oldStyleOffsets was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readLong());
                }
                this.oldStyleOffsets = newCollection;
            } else {
                this.oldStyleOffsets = new ArrayList<Long>();
            }
            this.timestamp = _version >= 1 ? _readable.readLong() : -1L;
            this.offset = _version >= 1 ? _readable.readLong() : -1L;
            this.leaderEpoch = _version >= 4 ? _readable.readInt() : 0;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetPartitionResponse");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            if (_version <= 0) {
                _writable.writeInt(this.oldStyleOffsets.size());
                for (Long oldStyleOffsetsElement : this.oldStyleOffsets) {
                    _writable.writeLong(oldStyleOffsetsElement);
                }
            } else if (!this.oldStyleOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default oldStyleOffsets at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeLong(this.timestamp);
            } else if (this.timestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default timestamp at version " + _version);
            }
            if (_version >= 1) {
                _writable.writeLong(this.offset);
            } else if (this.offset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default offset at version " + _version);
            }
            if (_version >= 4) {
                _writable.writeInt(this.leaderEpoch);
            } else if (this.leaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderEpoch at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetPartitionResponse");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            if (_version <= 0) {
                Object[] _nestedObjects = struct.getArray("old_style_offsets");
                this.oldStyleOffsets = new ArrayList<Long>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.oldStyleOffsets.add((Long)nestedObject);
                }
            } else {
                this.oldStyleOffsets = new ArrayList<Long>();
            }
            this.timestamp = _version >= 1 ? struct.getLong("timestamp") : -1L;
            this.offset = _version >= 1 ? struct.getLong("offset") : -1L;
            this.leaderEpoch = _version >= 4 ? struct.getInt("leader_epoch") : 0;
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetPartitionResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            if (_version <= 0) {
                Long[] _nestedObjects = new Long[this.oldStyleOffsets.size()];
                int i = 0;
                for (Long element : this.oldStyleOffsets) {
                    _nestedObjects[i++] = element;
                }
                struct.set("old_style_offsets", (Object)_nestedObjects);
            } else if (!this.oldStyleOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default oldStyleOffsets at version " + _version);
            }
            if (_version >= 1) {
                struct.set("timestamp", (Object)this.timestamp);
            } else if (this.timestamp != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default timestamp at version " + _version);
            }
            if (_version >= 1) {
                struct.set("offset", (Object)this.offset);
            } else if (this.offset != -1L) {
                throw new UnsupportedVersionException("Attempted to write a non-default offset at version " + _version);
            }
            if (_version >= 4) {
                struct.set("leader_epoch", (Object)this.leaderEpoch);
            } else if (this.leaderEpoch != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderEpoch at version " + _version);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetPartitionResponse");
            }
            _size += 4;
            _size += 2;
            if (_version <= 0) {
                int _arraySize = 0;
                _arraySize += 4;
                _size += (_arraySize += this.oldStyleOffsets.size() * 8);
            }
            if (_version >= 1) {
                _size += 8;
            }
            if (_version >= 1) {
                _size += 8;
            }
            if (_version >= 4) {
                _size += 4;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetPartitionResponse)) {
                return false;
            }
            ListOffsetPartitionResponse other = (ListOffsetPartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.oldStyleOffsets == null ? other.oldStyleOffsets != null : !this.oldStyleOffsets.equals(other.oldStyleOffsets)) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return this.leaderEpoch == other.leaderEpoch;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.oldStyleOffsets == null ? 0 : this.oldStyleOffsets.hashCode());
            hashCode = 31 * hashCode + ((int)(this.timestamp >> 32) ^ (int)this.timestamp);
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        public String toString() {
            return "ListOffsetPartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", oldStyleOffsets=" + MessageUtil.deepToString(this.oldStyleOffsets.iterator()) + ", timestamp=" + this.timestamp + ", offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public List<Long> oldStyleOffsets() {
            return this.oldStyleOffsets;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long offset() {
            return this.offset;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetPartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ListOffsetPartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public ListOffsetPartitionResponse setOldStyleOffsets(List<Long> v) {
            this.oldStyleOffsets = v;
            return this;
        }

        public ListOffsetPartitionResponse setTimestamp(long v) {
            this.timestamp = v;
            return this;
        }

        public ListOffsetPartitionResponse setOffset(long v) {
            this.offset = v;
            return this;
        }

        public ListOffsetPartitionResponse setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", Type.INT64, "The returned offset.")));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), new Field("timestamp", Type.INT64, "The timestamp associated with the returned offset."), new Field("offset", Type.INT64, "The returned offset."), new Field("leader_epoch", Type.INT32, ""));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class ListOffsetTopicResponse
    implements Message {
        private String name;
        private List<ListOffsetPartitionResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(ListOffsetPartitionResponse.SCHEMA_0), "Each partition in the response."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public ListOffsetTopicResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ListOffsetTopicResponse(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public ListOffsetTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<ListOffsetPartitionResponse>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopicResponse");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<ListOffsetPartitionResponse> newCollection = new ArrayList<ListOffsetPartitionResponse>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ListOffsetPartitionResponse(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetTopicResponse");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                ListOffsetPartitionResponse partitionsElement = (ListOffsetPartitionResponse)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ListOffsetTopicResponse");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<ListOffsetPartitionResponse>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new ListOffsetPartitionResponse((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ListOffsetTopicResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (ListOffsetPartitionResponse element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ListOffsetTopicResponse");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (ListOffsetPartitionResponse partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ListOffsetTopicResponse)) {
                return false;
            }
            ListOffsetTopicResponse other = (ListOffsetTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "ListOffsetTopicResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ListOffsetPartitionResponse> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ListOffsetTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public ListOffsetTopicResponse setPartitions(List<ListOffsetPartitionResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(ListOffsetPartitionResponse.SCHEMA_1), "Each partition in the response.")));
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(ListOffsetPartitionResponse.SCHEMA_4), "Each partition in the response."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

