/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class FetchResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private int sessionId;
    private List<FetchableTopicResponse> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(FetchableTopicResponse.SCHEMA_0), "The response topics."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema SCHEMA_11;
    public static final Schema[] SCHEMAS;

    public FetchResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public FetchResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public FetchResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.sessionId = 0;
        this.topics = new ArrayList<FetchableTopicResponse>();
    }

    @Override
    public short apiKey() {
        return 1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 11;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.errorCode = _version >= 7 ? _readable.readShort() : (short)0;
        this.sessionId = _version >= 7 ? _readable.readInt() : 0;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<FetchableTopicResponse> newCollection = new ArrayList<FetchableTopicResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new FetchableTopicResponse(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 7) {
            _writable.writeShort(this.errorCode);
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + _version);
        }
        if (_version >= 7) {
            _writable.writeInt(this.sessionId);
        } else if (this.sessionId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default sessionId at version " + _version);
        }
        _writable.writeInt(this.topics.size());
        for (FetchableTopicResponse topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = _version >= 7 ? struct.getShort("error_code") : (short)0;
        this.sessionId = _version >= 7 ? struct.getInt("session_id") : 0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<FetchableTopicResponse>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new FetchableTopicResponse((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        if (_version >= 7) {
            struct.set("error_code", (Object)this.errorCode);
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + _version);
        }
        if (_version >= 7) {
            struct.set("session_id", (Object)this.sessionId);
        } else if (this.sessionId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default sessionId at version " + _version);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (FetchableTopicResponse element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 4;
        }
        if (_version >= 7) {
            _size += 2;
        }
        if (_version >= 7) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (FetchableTopicResponse topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FetchResponseData)) {
            return false;
        }
        FetchResponseData other = (FetchResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.sessionId != other.sessionId) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + this.sessionId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "FetchResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", sessionId=" + this.sessionId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public List<FetchableTopicResponse> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FetchResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public FetchResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public FetchResponseData setSessionId(int v) {
        this.sessionId = v;
        return this;
    }

    public FetchResponseData setTopics(List<FetchableTopicResponse> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(FetchableTopicResponse.SCHEMA_0), "The response topics.")));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(FetchableTopicResponse.SCHEMA_4), "The response topics."));
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(FetchableTopicResponse.SCHEMA_5), "The response topics."));
        SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top level response error code."), new Field("session_id", Type.INT32, "The fetch session ID, or 0 if this is not part of a fetch session."), new Field("topics", new ArrayOf(FetchableTopicResponse.SCHEMA_5), "The response topics."))));
        SCHEMA_11 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top level response error code."), new Field("session_id", Type.INT32, "The fetch session ID, or 0 if this is not part of a fetch session."), new Field("topics", new ArrayOf(FetchableTopicResponse.SCHEMA_11), "The response topics."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
    }

    public static class AbortedTransaction
    implements Message {
        private long producerId;
        private long firstOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;

        public AbortedTransaction(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AbortedTransaction(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public AbortedTransaction() {
            this.producerId = 0L;
            this.firstOffset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AbortedTransaction");
            }
            this.producerId = _readable.readLong();
            this.firstOffset = _readable.readLong();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AbortedTransaction");
            }
            int _numTaggedFields = 0;
            _writable.writeLong(this.producerId);
            _writable.writeLong(this.firstOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AbortedTransaction");
            }
            this._unknownTaggedFields = null;
            this.producerId = struct.getLong("producer_id");
            this.firstOffset = struct.getLong("first_offset");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AbortedTransaction");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("producer_id", (Object)this.producerId);
            struct.set("first_offset", (Object)this.firstOffset);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AbortedTransaction");
            }
            _size += 8;
            _size += 8;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AbortedTransaction)) {
                return false;
            }
            AbortedTransaction other = (AbortedTransaction)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            return this.firstOffset == other.firstOffset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + ((int)(this.firstOffset >> 32) ^ (int)this.firstOffset);
            return hashCode;
        }

        public String toString() {
            return "AbortedTransaction(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AbortedTransaction setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public AbortedTransaction setFirstOffset(long v) {
            this.firstOffset = v;
            return this;
        }

        static {
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = new Schema(new Field("producer_id", Type.INT64, "The producer id associated with the aborted transaction."), new Field("first_offset", Type.INT64, "The first offset in the aborted transaction."))))))));
            SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class FetchablePartitionResponse
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private long highWatermark;
        private long lastStableOffset;
        private long logStartOffset;
        private List<AbortedTransaction> aborted;
        private int preferredReadReplica;
        private byte[] records;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;

        public FetchablePartitionResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public FetchablePartitionResponse(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public FetchablePartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.highWatermark = 0L;
            this.lastStableOffset = -1L;
            this.logStartOffset = -1L;
            this.aborted = new ArrayList<AbortedTransaction>();
            this.preferredReadReplica = 0;
            this.records = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchablePartitionResponse");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.highWatermark = _readable.readLong();
            this.lastStableOffset = _version >= 4 ? _readable.readLong() : -1L;
            this.logStartOffset = _version >= 5 ? _readable.readLong() : -1L;
            if (_version >= 4) {
                int arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    this.aborted = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<AbortedTransaction> newCollection = new ArrayList<AbortedTransaction>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        newCollection.add(new AbortedTransaction(_readable, _version));
                    }
                    this.aborted = newCollection;
                }
            } else {
                this.aborted = new ArrayList<AbortedTransaction>();
            }
            this.preferredReadReplica = _version >= 11 ? _readable.readInt() : 0;
            int length = _readable.readInt();
            if (length < 0) {
                this.records = null;
            } else {
                byte[] newBytes = _readable.readArray(length);
                this.records = newBytes;
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchablePartitionResponse");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            _writable.writeLong(this.highWatermark);
            if (_version >= 4) {
                _writable.writeLong(this.lastStableOffset);
            }
            if (_version >= 5) {
                _writable.writeLong(this.logStartOffset);
            }
            if (_version >= 4) {
                if (this.aborted == null) {
                    _writable.writeInt(-1);
                } else {
                    _writable.writeInt(this.aborted.size());
                    for (AbortedTransaction abortedElement : this.aborted) {
                        abortedElement.write(_writable, _cache, _version);
                    }
                }
            } else if (this.aborted == null || !this.aborted.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default aborted at version " + _version);
            }
            if (_version >= 11) {
                _writable.writeInt(this.preferredReadReplica);
            }
            if (this.records == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.records.length);
                _writable.writeByteArray(this.records);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchablePartitionResponse");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            this.highWatermark = struct.getLong("high_watermark");
            this.lastStableOffset = _version >= 4 ? struct.getLong("last_stable_offset") : -1L;
            this.logStartOffset = _version >= 5 ? struct.getLong("log_start_offset") : -1L;
            if (_version >= 4) {
                Object[] _nestedObjects = struct.getArray("aborted");
                if (_nestedObjects == null) {
                    this.aborted = null;
                } else {
                    this.aborted = new ArrayList<AbortedTransaction>(_nestedObjects.length);
                    for (Object nestedObject : _nestedObjects) {
                        this.aborted.add(new AbortedTransaction((Struct)nestedObject, _version));
                    }
                }
            } else {
                this.aborted = new ArrayList<AbortedTransaction>();
            }
            this.preferredReadReplica = _version >= 11 ? struct.getInt("preferred_read_replica") : 0;
            this.records = struct.getByteArray("records");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchablePartitionResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("high_watermark", (Object)this.highWatermark);
            if (_version >= 4) {
                struct.set("last_stable_offset", (Object)this.lastStableOffset);
            }
            if (_version >= 5) {
                struct.set("log_start_offset", (Object)this.logStartOffset);
            }
            if (_version >= 4) {
                if (this.aborted == null) {
                    struct.set("aborted", null);
                } else {
                    Struct[] _nestedObjects = new Struct[this.aborted.size()];
                    int i = 0;
                    for (AbortedTransaction element : this.aborted) {
                        _nestedObjects[i++] = element.toStruct(_version);
                    }
                    struct.set("aborted", (Object)_nestedObjects);
                }
            } else if (this.aborted == null || !this.aborted.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default aborted at version " + _version);
            }
            if (_version >= 11) {
                struct.set("preferred_read_replica", (Object)this.preferredReadReplica);
            }
            struct.setByteArray("records", this.records);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchablePartitionResponse");
            }
            _size += 4;
            _size += 2;
            _size += 8;
            if (_version >= 4) {
                _size += 8;
            }
            if (_version >= 5) {
                _size += 8;
            }
            if (_version >= 4) {
                if (this.aborted == null) {
                    _size += 4;
                } else {
                    int _arraySize = 0;
                    _arraySize += 4;
                    for (AbortedTransaction abortedElement : this.aborted) {
                        _arraySize += abortedElement.size(_cache, _version);
                    }
                    _size += _arraySize;
                }
            }
            if (_version >= 11) {
                _size += 4;
            }
            if (this.records == null) {
                _size += 4;
            } else {
                int _bytesSize = this.records.length;
                _size += (_bytesSize += 4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchablePartitionResponse)) {
                return false;
            }
            FetchablePartitionResponse other = (FetchablePartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.highWatermark != other.highWatermark) {
                return false;
            }
            if (this.lastStableOffset != other.lastStableOffset) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.aborted == null ? other.aborted != null : !this.aborted.equals(other.aborted)) {
                return false;
            }
            if (this.preferredReadReplica != other.preferredReadReplica) {
                return false;
            }
            return Arrays.equals(this.records, other.records);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.highWatermark >> 32) ^ (int)this.highWatermark);
            hashCode = 31 * hashCode + ((int)(this.lastStableOffset >> 32) ^ (int)this.lastStableOffset);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + (this.aborted == null ? 0 : this.aborted.hashCode());
            hashCode = 31 * hashCode + this.preferredReadReplica;
            hashCode = 31 * hashCode + Arrays.hashCode(this.records);
            return hashCode;
        }

        public String toString() {
            return "FetchablePartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", highWatermark=" + this.highWatermark + ", lastStableOffset=" + this.lastStableOffset + ", logStartOffset=" + this.logStartOffset + ", aborted=" + (this.aborted == null ? "null" : MessageUtil.deepToString(this.aborted.iterator())) + ", preferredReadReplica=" + this.preferredReadReplica + ", records=" + Arrays.toString(this.records) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long highWatermark() {
            return this.highWatermark;
        }

        public long lastStableOffset() {
            return this.lastStableOffset;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public List<AbortedTransaction> aborted() {
            return this.aborted;
        }

        public int preferredReadReplica() {
            return this.preferredReadReplica;
        }

        public byte[] records() {
            return this.records;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchablePartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public FetchablePartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public FetchablePartitionResponse setHighWatermark(long v) {
            this.highWatermark = v;
            return this;
        }

        public FetchablePartitionResponse setLastStableOffset(long v) {
            this.lastStableOffset = v;
            return this;
        }

        public FetchablePartitionResponse setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public FetchablePartitionResponse setAborted(List<AbortedTransaction> v) {
            this.aborted = v;
            return this;
        }

        public FetchablePartitionResponse setPreferredReadReplica(int v) {
            this.preferredReadReplica = v;
            return this;
        }

        public FetchablePartitionResponse setRecords(byte[] v) {
            this.records = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partiiton index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", Type.INT64, "The current high water mark."), new Field("records", Type.NULLABLE_BYTES, "The record data."))));
            SCHEMA_4 = new Schema(new Field("partition_index", Type.INT32, "The partiiton index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", Type.INT64, "The current high water mark."), new Field("last_stable_offset", Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("aborted", ArrayOf.nullable(AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("records", Type.NULLABLE_BYTES, "The record data."));
            SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partiiton index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", Type.INT64, "The current high water mark."), new Field("last_stable_offset", Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("log_start_offset", Type.INT64, "The current log start offset."), new Field("aborted", ArrayOf.nullable(AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("records", Type.NULLABLE_BYTES, "The record data."))))));
            SCHEMA_11 = new Schema(new Field("partition_index", Type.INT32, "The partiiton index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", Type.INT64, "The current high water mark."), new Field("last_stable_offset", Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("log_start_offset", Type.INT64, "The current log start offset."), new Field("aborted", ArrayOf.nullable(AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("preferred_read_replica", Type.INT32, "The preferred read replica for the consumer to use on its next fetch request"), new Field("records", Type.NULLABLE_BYTES, "The record data."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class FetchableTopicResponse
    implements Message {
        private String name;
        private List<FetchablePartitionResponse> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;

        public FetchableTopicResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public FetchableTopicResponse(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public FetchableTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<FetchablePartitionResponse>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchableTopicResponse");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<FetchablePartitionResponse> newCollection = new ArrayList<FetchablePartitionResponse>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new FetchablePartitionResponse(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchableTopicResponse");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                FetchablePartitionResponse partitionsElement = (FetchablePartitionResponse)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchableTopicResponse");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<FetchablePartitionResponse>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new FetchablePartitionResponse((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FetchableTopicResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (FetchablePartitionResponse element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchableTopicResponse");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (FetchablePartitionResponse partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchableTopicResponse)) {
                return false;
            }
            FetchableTopicResponse other = (FetchableTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "FetchableTopicResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<FetchablePartitionResponse> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchableTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public FetchableTopicResponse setPartitions(List<FetchablePartitionResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(FetchablePartitionResponse.SCHEMA_0), "The topic partitions."))));
            SCHEMA_4 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(FetchablePartitionResponse.SCHEMA_4), "The topic partitions."));
            SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(FetchablePartitionResponse.SCHEMA_5), "The topic partitions."))))));
            SCHEMA_11 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(FetchablePartitionResponse.SCHEMA_11), "The topic partitions."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }
}

