/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.Record;

public class ControlRecordUtils {
    public static final short KRAFT_VERSION_CURRENT_VERSION = 0;
    public static final short LEADER_CHANGE_CURRENT_VERSION = 0;
    public static final short SNAPSHOT_FOOTER_CURRENT_VERSION = 0;
    public static final short SNAPSHOT_HEADER_CURRENT_VERSION = 0;
    public static final short KRAFT_VOTERS_CURRENT_VERSION = 0;

    public static LeaderChangeMessage deserializeLeaderChangeMessage(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        ControlRecordUtils.validateControlRecordType(ControlRecordType.LEADER_CHANGE, recordType);
        return ControlRecordUtils.deserializeLeaderChangeMessage(record.value());
    }

    public static LeaderChangeMessage deserializeLeaderChangeMessage(ByteBuffer data) {
        return new LeaderChangeMessage(new ByteBufferAccessor(data.slice()), 0);
    }

    public static SnapshotHeaderRecord deserializeSnapshotHeaderRecord(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        ControlRecordUtils.validateControlRecordType(ControlRecordType.SNAPSHOT_HEADER, recordType);
        return ControlRecordUtils.deserializeSnapshotHeaderRecord(record.value());
    }

    public static SnapshotHeaderRecord deserializeSnapshotHeaderRecord(ByteBuffer data) {
        return new SnapshotHeaderRecord(new ByteBufferAccessor(data.slice()), 0);
    }

    public static SnapshotFooterRecord deserializeSnapshotFooterRecord(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        ControlRecordUtils.validateControlRecordType(ControlRecordType.SNAPSHOT_FOOTER, recordType);
        return ControlRecordUtils.deserializeSnapshotFooterRecord(record.value());
    }

    public static SnapshotFooterRecord deserializeSnapshotFooterRecord(ByteBuffer data) {
        return new SnapshotFooterRecord(new ByteBufferAccessor(data.slice()), 0);
    }

    public static KRaftVersionRecord deserializeKRaftVersionRecord(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        ControlRecordUtils.validateControlRecordType(ControlRecordType.KRAFT_VERSION, recordType);
        return ControlRecordUtils.deserializeKRaftVersionRecord(record.value());
    }

    public static KRaftVersionRecord deserializeKRaftVersionRecord(ByteBuffer data) {
        return new KRaftVersionRecord(new ByteBufferAccessor(data.slice()), 0);
    }

    public static VotersRecord deserializeVotersRecord(Record record) {
        ControlRecordType recordType = ControlRecordType.parse(record.key());
        ControlRecordUtils.validateControlRecordType(ControlRecordType.KRAFT_VOTERS, recordType);
        return ControlRecordUtils.deserializeVotersRecord(record.value());
    }

    public static VotersRecord deserializeVotersRecord(ByteBuffer data) {
        return new VotersRecord(new ByteBufferAccessor(data.slice()), 0);
    }

    private static void validateControlRecordType(ControlRecordType expected, ControlRecordType actual) {
        if (actual != expected) {
            throw new IllegalArgumentException(String.format("Expected %s control record type(%d), but found %s", new Object[]{expected, expected.type(), actual}));
        }
    }
}

