/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.RegexValidator;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexRouter<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger log = LoggerFactory.getLogger(RegexRouter.class);
    public static final String OVERVIEW_DOC = "Update the record topic using the configured regular expression and replacement string.<p/>Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. If the pattern matches the input topic, <code>java.util.regex.Matcher#replaceFirst()</code> is used with the replacement string to obtain the new topic.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("regex", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new RegexValidator(), ConfigDef.Importance.HIGH, "Regular expression to use for matching.").define("replacement", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, "Replacement string.");
    private Pattern regex;
    private String replacement;

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.regex = Pattern.compile(config.getString("regex"));
        this.replacement = config.getString("replacement");
    }

    public R apply(R record) {
        Matcher matcher = this.regex.matcher(record.topic());
        if (matcher.matches()) {
            String topic = matcher.replaceFirst(this.replacement);
            log.trace("Rerouting from topic '{}' to new topic '{}'", (Object)record.topic(), (Object)topic);
            return (R)record.newRecord(topic, record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp());
        }
        log.trace("Not rerouting topic '{}' as it does not match the configured regex", (Object)record.topic());
        return record;
    }

    public void close() {
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    private static interface ConfigName {
        public static final String REGEX = "regex";
        public static final String REPLACEMENT = "replacement";
    }
}

