/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectUtils.class);

    public static Long checkAndConvertTimestamp(Long timestamp) {
        if (timestamp == null || timestamp >= 0L) {
            return timestamp;
        }
        if (timestamp == -1L) {
            return null;
        }
        throw new InvalidRecordException(String.format("Invalid record timestamp %d", timestamp));
    }

    public static String lookupKafkaClusterId(WorkerConfig config) {
        log.info("Creating Kafka admin client");
        try (Admin adminClient = Admin.create((Map)config.originals());){
            String string = ConnectUtils.lookupKafkaClusterId(adminClient);
            return string;
        }
    }

    static String lookupKafkaClusterId(Admin adminClient) {
        log.debug("Looking up Kafka cluster ID");
        try {
            KafkaFuture clusterIdFuture = adminClient.describeCluster().clusterId();
            if (clusterIdFuture == null) {
                log.info("Kafka cluster version is too old to return cluster ID");
                return null;
            }
            log.debug("Fetching Kafka cluster ID");
            String kafkaClusterId = (String)clusterIdFuture.get();
            log.info("Kafka cluster ID: {}", (Object)kafkaClusterId);
            return kafkaClusterId;
        }
        catch (InterruptedException e) {
            throw new ConnectException("Unexpectedly interrupted when looking up Kafka cluster info", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ConnectException("Failed to connect to and describe Kafka cluster. Check worker's broker connection and security properties.", (Throwable)e);
        }
    }

    public static void ensureProperty(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        ConnectUtils.ensurePropertyAndGetWarning(props, key, expectedValue, justification, caseSensitive).ifPresent(arg_0 -> ((Logger)log).warn(arg_0));
    }

    static Optional<String> ensurePropertyAndGetWarning(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        boolean matchesExpectedValue;
        if (!props.containsKey(key)) {
            props.put(key, expectedValue);
            return Optional.empty();
        }
        String value = Objects.toString(props.get(key));
        boolean bl = matchesExpectedValue = caseSensitive ? expectedValue.equals(value) : expectedValue.equalsIgnoreCase(value);
        if (matchesExpectedValue) {
            return Optional.empty();
        }
        props.put(key, expectedValue);
        justification = justification != null ? " " + justification : "";
        return Optional.of(String.format("The value '%s' for the '%s' property will be ignored as it cannot be overridden%s. The value '%s' will be used instead.", value, key, justification, expectedValue));
    }

    public static void addMetricsContextProperties(Map<String, Object> prop, WorkerConfig config, String clusterId) {
        ConnectUtils.addMetricsContextProperties(prop, config, clusterId, null);
    }

    public static void addMetricsContextProperties(Map<String, Object> prop, WorkerConfig config, String clusterId, ConnectorTaskId connectorTaskId) {
        prop.putAll(config.originalsWithPrefix("metrics.context.", false));
        prop.put("metrics.context.connect.kafka.cluster.id", clusterId);
        Object groupId = config.originals().get("group.id");
        if (groupId != null) {
            prop.put("metrics.context.connect.group.id", groupId);
        }
        if (connectorTaskId != null) {
            prop.put("metrics.context.resource.connector", connectorTaskId.connector());
            prop.put("metrics.context.resource.task", connectorTaskId.task());
        }
    }

    public static void addConfluentMetricsContextProperties(Map<String, Object> prop) {
        prop.put("metrics.context.resource.type", "connect");
        prop.put("metrics.context.resource.version", AppInfoParser.getVersion());
        prop.put("metrics.context.resource.commit.id", AppInfoParser.getCommitId());
    }

    public static boolean isSinkConnector(Connector connector) {
        return SinkConnector.class.isAssignableFrom(connector.getClass());
    }

    public static boolean isSourceConnector(Connector connector) {
        return SourceConnector.class.isAssignableFrom(connector.getClass());
    }

    public static <K, I, O> Map<K, O> transformValues(Map<K, I> map, Function<I, O> transformation) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, transformation.compose(Map.Entry::getValue)));
    }

    public static <I> List<I> combineCollections(Collection<Collection<I>> collections) {
        return ConnectUtils.combineCollections(collections, Function.identity());
    }

    public static <I, T> List<T> combineCollections(Collection<I> collection, Function<I, Collection<T>> extractCollection) {
        return ConnectUtils.combineCollections(collection, extractCollection, Collectors.toList());
    }

    public static <I, T, C> C combineCollections(Collection<I> collection, Function<I, Collection<T>> extractCollection, Collector<T, ?, C> collector) {
        return collection.stream().map(extractCollection).flatMap(Collection::stream).collect(collector);
    }

    public static ConnectException maybeWrap(Throwable t, String message) {
        if (t == null) {
            return null;
        }
        if (t instanceof ConnectException) {
            return (ConnectException)t;
        }
        return new ConnectException(message, t);
    }
}

