/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class PluginDesc<T>
implements Comparable<PluginDesc<T>> {
    private final Class<? extends T> klass;
    private final String name;
    private final String version;
    private final DefaultArtifactVersion encodedVersion;
    private final PluginType type;
    private final String typeName;
    private final String location;

    public PluginDesc(Class<? extends T> klass, String version, ClassLoader loader) {
        this.klass = klass;
        this.name = klass.getName();
        this.version = version != null ? version : "null";
        this.encodedVersion = new DefaultArtifactVersion(this.version);
        this.type = PluginType.from(klass);
        this.typeName = this.type.toString();
        this.location = loader instanceof PluginClassLoader ? ((PluginClassLoader)loader).location() : "classpath";
    }

    public String toString() {
        return "PluginDesc{klass=" + this.klass + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", encodedVersion=" + this.encodedVersion + ", type=" + (Object)((Object)this.type) + ", typeName='" + this.typeName + '\'' + ", location='" + this.location + '\'' + '}';
    }

    public Class<? extends T> pluginClass() {
        return this.klass;
    }

    @JsonProperty(value="class")
    public String className() {
        return this.name;
    }

    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public PluginType type() {
        return this.type;
    }

    @JsonProperty(value="type")
    public String typeName() {
        return this.typeName;
    }

    @JsonProperty(value="location")
    public String location() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginDesc)) {
            return false;
        }
        PluginDesc that = (PluginDesc)o;
        return Objects.equals(this.klass, that.klass) && Objects.equals(this.version, that.version) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.klass, this.version, this.type});
    }

    @Override
    public int compareTo(PluginDesc<T> other) {
        int nameComp = this.name.compareTo(other.name);
        return nameComp != 0 ? nameComp : this.encodedVersion.compareTo((ArtifactVersion)other.encodedVersion);
    }
}

