/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerTransactionContext
implements TransactionContext {
    private static final Logger log = LoggerFactory.getLogger(WorkerTransactionContext.class);
    private final Set<SourceRecord> commitableRecords = new HashSet<SourceRecord>();
    private final Set<SourceRecord> abortableRecords = new HashSet<SourceRecord>();
    private boolean batchCommitRequested = false;
    private boolean batchAbortRequested = false;

    public synchronized void commitTransaction() {
        this.batchCommitRequested = true;
    }

    public synchronized void commitTransaction(SourceRecord record) {
        Objects.requireNonNull(record, "Source record used to define transaction boundaries may not be null");
        this.commitableRecords.add(record);
    }

    public synchronized void abortTransaction() {
        this.batchAbortRequested = true;
    }

    public synchronized void abortTransaction(SourceRecord record) {
        Objects.requireNonNull(record, "Source record used to define transaction boundaries may not be null");
        this.abortableRecords.add(record);
    }

    public synchronized boolean shouldCommitBatch() {
        this.checkBatchRequestsConsistency();
        boolean result = this.batchCommitRequested;
        this.batchCommitRequested = false;
        return result;
    }

    public synchronized boolean shouldAbortBatch() {
        this.checkBatchRequestsConsistency();
        boolean result = this.batchAbortRequested;
        this.batchAbortRequested = false;
        return result;
    }

    public synchronized boolean shouldCommitOn(SourceRecord record) {
        this.checkRecordRequestConsistency(record);
        return this.commitableRecords.remove(record);
    }

    public synchronized boolean shouldAbortOn(SourceRecord record) {
        this.checkRecordRequestConsistency(record);
        return this.abortableRecords.remove(record);
    }

    private void checkBatchRequestsConsistency() {
        if (this.batchCommitRequested && this.batchAbortRequested) {
            throw new IllegalStateException("Connector requested both commit and abort of same transaction");
        }
    }

    private void checkRecordRequestConsistency(SourceRecord record) {
        if (this.commitableRecords.contains(record) && this.abortableRecords.contains(record)) {
            log.trace("Connector will fail as it has requested both commit and abort of transaction for same record with hash {} ", (Object)record.hashCode());
            throw new IllegalStateException(String.format("Connector requested both commit and abort of same record against topic/partition %s/%s", record.topic(), record.kafkaPartition()));
        }
    }
}

