/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.jmeter.samplers.SampleResult;

public class HTTPSampleResult
extends SampleResult {
    private static final long serialVersionUID = 241L;
    private static final Set<String> METHODS_WITHOUT_BODY = new HashSet<String>(Arrays.asList("HEAD", "OPTIONS", "TRACE"));
    private String cookies = "";
    private String method;
    private String redirectLocation;
    private String queryString = "";
    private static final String HTTP_NO_CONTENT_CODE = Integer.toString(204);
    private static final String HTTP_NO_CONTENT_MSG = "No Content";

    public HTTPSampleResult() {
    }

    public HTTPSampleResult(long elapsed) {
        super(elapsed, true);
    }

    public HTTPSampleResult(HTTPSampleResult res) {
        super((SampleResult)res);
        this.method = res.method;
        this.cookies = res.cookies;
        this.queryString = res.queryString;
        this.redirectLocation = res.redirectLocation;
    }

    public void setHTTPMethod(String method) {
        this.method = method;
    }

    public String getHTTPMethod() {
        return this.method;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public boolean isRedirect() {
        String[] redirectCodes = new String[]{"301", "302", "303"};
        String code = this.getResponseCode();
        for (String redirectCode : redirectCodes) {
            if (!redirectCode.equals(code)) continue;
            return true;
        }
        return "307".equals(code) && ("GET".equals(this.getHTTPMethod()) || "HEAD".equals(this.getHTTPMethod()));
    }

    public String getSamplerData() {
        String sampData;
        StringBuilder sb = new StringBuilder();
        sb.append(this.method);
        URL u = super.getURL();
        if (u != null) {
            sb.append(' ');
            sb.append(u.toString());
            sb.append('\n');
            if (!METHODS_WITHOUT_BODY.contains(this.method)) {
                sb.append("\n").append(this.method).append(" data:\n");
                sb.append(this.queryString);
                sb.append('\n');
            }
            if (this.cookies.length() > 0) {
                sb.append("\nCookie Data:\n");
                sb.append(this.cookies);
            } else {
                sb.append("\n[no cookies]");
            }
            sb.append('\n');
        }
        if ((sampData = super.getSamplerData()) != null) {
            sb.append(sampData);
        }
        return sb.toString();
    }

    public String getCookies() {
        return this.cookies;
    }

    public void setCookies(String string) {
        this.cookies = string == null ? "" : string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string == null ? "" : string;
    }

    public String getDataEncodingWithDefault(String defaultEncoding) {
        String dataEncodingNoDefault = this.getDataEncodingNoDefault();
        if (dataEncodingNoDefault != null && dataEncodingNoDefault.length() > 0) {
            return dataEncodingNoDefault;
        }
        return defaultEncoding;
    }

    public String getDataEncodingNoDefault() {
        if (super.getDataEncodingNoDefault() == null && this.getContentType().startsWith("text/html")) {
            int tagend;
            byte[] bytes = this.getResponseData();
            String prefix = new String(bytes, 0, Math.min(bytes.length, 2000), Charset.forName(DEFAULT_HTTP_ENCODING));
            String matchAgainst = prefix.toLowerCase(Locale.ENGLISH);
            String metaTag = "<meta http-equiv=\"content-type\" content=\"";
            int tagstart = matchAgainst.indexOf("<meta http-equiv=\"content-type\" content=\"");
            if (tagstart != -1 && (tagend = prefix.indexOf(34, tagstart += "<meta http-equiv=\"content-type\" content=\"".length())) != -1) {
                String ct = prefix.substring(tagstart, tagend);
                this.setEncodingAndType(ct);
            }
        }
        return super.getDataEncodingNoDefault();
    }

    public void setResponseNoContent() {
        this.setResponseCode(HTTP_NO_CONTENT_CODE);
        this.setResponseMessage(HTTP_NO_CONTENT_MSG);
    }

    public List<String> getSearchableTokens() throws Exception {
        ArrayList<String> list = new ArrayList<String>(super.getSearchableTokens());
        list.add(this.getQueryString());
        list.add(this.getCookies());
        list.add(this.getUrlAsString());
        return list;
    }
}

