/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.protocol.http.modifier.URLRewritingModifier;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

@TestElementMetadata(labelResource="http_url_rewriting_modifier_title")
public class URLRewritingModifierGui
extends AbstractPreProcessorGui {
    private static final long serialVersionUID = 240L;
    private JLabeledTextField argumentName;
    private JCheckBox pathExt;
    private JCheckBox pathExtNoEquals;
    private JCheckBox pathExtNoQuestionmark;
    private JCheckBox shouldCache;
    private JCheckBox encode;

    public String getLabelResource() {
        return "http_url_rewriting_modifier_title";
    }

    public URLRewritingModifierGui() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel mainPanel = new VerticalPanel();
        this.argumentName = new JLabeledTextField(JMeterUtils.getResString((String)"session_argument_name"), 10);
        mainPanel.add((Component)this.argumentName);
        this.pathExt = new JCheckBox(JMeterUtils.getResString((String)"path_extension_choice"));
        mainPanel.add((Component)this.pathExt);
        this.pathExtNoEquals = new JCheckBox(JMeterUtils.getResString((String)"path_extension_dont_use_equals"));
        mainPanel.add((Component)this.pathExtNoEquals);
        this.pathExtNoQuestionmark = new JCheckBox(JMeterUtils.getResString((String)"path_extension_dont_use_questionmark"));
        mainPanel.add((Component)this.pathExtNoQuestionmark);
        this.shouldCache = new JCheckBox(JMeterUtils.getResString((String)"cache_session_id"));
        this.shouldCache.setSelected(true);
        mainPanel.add((Component)this.shouldCache);
        this.encode = new JCheckBox(JMeterUtils.getResString((String)"encode"));
        this.encode.setSelected(false);
        mainPanel.add((Component)this.encode);
        this.add((Component)mainPanel, "Center");
    }

    public TestElement createTestElement() {
        URLRewritingModifier modifier = new URLRewritingModifier();
        this.modifyTestElement((TestElement)modifier);
        return modifier;
    }

    public void modifyTestElement(TestElement modifier) {
        super.configureTestElement(modifier);
        URLRewritingModifier rewritingModifier = (URLRewritingModifier)modifier;
        rewritingModifier.setArgumentName(this.argumentName.getText());
        rewritingModifier.setPathExtension(this.pathExt.isSelected());
        rewritingModifier.setPathExtensionNoEquals(this.pathExtNoEquals.isSelected());
        rewritingModifier.setPathExtensionNoQuestionmark(this.pathExtNoQuestionmark.isSelected());
        rewritingModifier.setShouldCache(this.shouldCache.isSelected());
        rewritingModifier.setEncode(this.encode.isSelected());
    }

    public void clearGui() {
        super.clearGui();
        this.argumentName.setText("");
        this.pathExt.setSelected(false);
        this.pathExtNoEquals.setSelected(false);
        this.pathExtNoQuestionmark.setSelected(false);
        this.shouldCache.setSelected(false);
        this.encode.setSelected(false);
    }

    public void configure(TestElement el) {
        URLRewritingModifier rewritingModifier = (URLRewritingModifier)el;
        this.argumentName.setText(rewritingModifier.getArgumentName());
        this.pathExt.setSelected(rewritingModifier.isPathExtension());
        this.pathExtNoEquals.setSelected(rewritingModifier.isPathExtensionNoEquals());
        this.pathExtNoQuestionmark.setSelected(rewritingModifier.isPathExtensionNoQuestionmark());
        this.shouldCache.setSelected(rewritingModifier.shouldCache());
        this.encode.setSelected(rewritingModifier.encode());
        super.configure(el);
    }
}

