/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpParams;
import org.apache.jmeter.protocol.http.util.HC4TrustAllSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazySchemeSocketFactory
implements SchemeLayeredSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LazySchemeSocketFactory.class);

    public Socket createSocket(HttpParams params) throws IOException {
        return AdapteeHolder.getINSTANCE().createSocket(params);
    }

    public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        return AdapteeHolder.getINSTANCE().connectSocket(sock, remoteAddress, localAddress, params);
    }

    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        return AdapteeHolder.getINSTANCE().isSecure(sock);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpParams params) throws IOException, UnknownHostException {
        return AdapteeHolder.getINSTANCE().createLayeredSocket(socket, target, port, params);
    }

    private static class AdapteeHolder {
        private static final SchemeLayeredSocketFactory ADAPTEE = AdapteeHolder.checkAndInit();

        private AdapteeHolder() {
        }

        private static SchemeLayeredSocketFactory checkAndInit() throws SSLInitializationException {
            LOG.info("Setting up HTTPS TrustAll Socket Factory");
            try {
                return new HC4TrustAllSSLSocketFactory();
            }
            catch (GeneralSecurityException e) {
                LOG.warn("Failed to initialise HTTPS HC4TrustAllSSLSocketFactory", (Throwable)e);
                return SSLSocketFactory.getSocketFactory();
            }
        }

        static SchemeLayeredSocketFactory getINSTANCE() {
            return ADAPTEE;
        }
    }
}

