/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.lib;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shacl.lib.G;

public class Transitive {
    public static void transitiveInc(Graph graph, boolean forward, Node node, Node predicate, Collection<Node> output) {
        Transitive.recurse(graph, forward, node, predicate, output);
    }

    public static void transitiveExc(Graph graph, boolean forward, Node node, Node predicate, Collection<Node> output) {
        Iterator<Node> iter = Transitive.singleStep(graph, forward, node, predicate);
        HashSet<Node> visited = new HashSet<Node>();
        while (iter.hasNext()) {
            Node n1 = iter.next();
            Transitive.recurse_1(graph, forward, 1, -1, n1, predicate, visited, output);
        }
    }

    private static void recurse(Graph graph, boolean forward, Node node, Node predicate, Collection<Node> output) {
        HashSet<Node> visited = new HashSet<Node>();
        Transitive.recurse_1(graph, forward, 0, -1, node, predicate, visited, output);
    }

    private static void recurse_1(Graph graph, boolean forward, int stepCount, int maxStepCount, Node node, Node predicate, Set<Node> visited, Collection<Node> output) {
        if (maxStepCount >= 0 && stepCount > maxStepCount) {
            return;
        }
        if (!visited.add(node)) {
            return;
        }
        output.add(node);
        Iterator<Node> iter1 = Transitive.singleStep(graph, forward, node, predicate);
        while (iter1.hasNext()) {
            Node n1 = iter1.next();
            Transitive.recurse_1(graph, forward, stepCount + 1, maxStepCount, n1, predicate, visited, output);
        }
    }

    private static Iterator<Node> singleStep(Graph graph, boolean forward, Node node, Node property) {
        if (forward) {
            return G.find(graph, node, property, Node.ANY).mapWith(Triple::getObject);
        }
        return G.find(graph, Node.ANY, property, node).mapWith(Triple::getSubject);
    }
}

