/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.filters;

import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import org.jclouds.b2.domain.Authorization;
import org.jclouds.collect.Memoized;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public final class RequestAuthorizationDownload
implements HttpRequestFilter {
    private final Supplier<Authorization> auth;

    @Inject
    RequestAuthorizationDownload(@Memoized Supplier<Authorization> auth) {
        this.auth = auth;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Authorization auth = (Authorization)this.auth.get();
        URI endpoint = request.getEndpoint();
        endpoint = URI.create(auth.downloadUrl() + (String)(endpoint.getPort() == -1 ? "" : ":" + endpoint.getPort()) + endpoint.getRawPath() + (String)(endpoint.getQuery() == null ? "" : "?" + endpoint.getQuery()));
        request = ((HttpRequest.Builder)request.toBuilder().endpoint(endpoint).replaceHeader("Authorization", new String[]{auth.authorizationToken()})).build();
        return request;
    }
}

