/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.integration.internal.BaseBlobIntegrationTest;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class TransientBlobIntegrationTest
extends BaseBlobIntegrationTest {
    public TransientBlobIntegrationTest() {
        this.provider = "transient";
    }

    @Override
    @Test(groups={"integration", "live"})
    public void testSetBlobAccess() throws Exception {
        throw new SkipException("transient does not support anonymous access");
    }

    @Override
    protected void checkMPUParts(Blob blob, List<MultipartPart> parts) {
        Assertions.assertThat((String)blob.getMetadata().getETag()).endsWith((CharSequence)String.format("-%d\"", parts.size()));
        Hasher eTagHasher = Hashing.md5().newHasher();
        for (MultipartPart part : parts) {
            eTagHasher.putBytes(BaseEncoding.base16().lowerCase().decode((CharSequence)part.partETag()));
        }
        String expectedETag = "\"" + eTagHasher.hash() + "-" + parts.size() + "\"";
        Assertions.assertThat((String)blob.getMetadata().getETag()).isEqualTo(expectedETag);
    }
}

