/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import jakarta.inject.Provider;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.functions.ResourceMetadataToRelativePathResourceMetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ResourceMetadataToRelativePathResourceMetadataTest {
    private ResourceMetadataToRelativePathResourceMetadata parser = new ResourceMetadataToRelativePathResourceMetadata();
    private Provider<MutableBlobMetadata> blobMetadataProvider = new Provider<MutableBlobMetadata>(){

        public MutableBlobMetadata get() {
            return new MutableBlobMetadataImpl();
        }
    };

    @Test
    public void test1() {
        MutableBlobMetadata md = (MutableBlobMetadata)this.blobMetadataProvider.get();
        md.setName("dir/");
        md.setId("dir/");
        StorageMetadata rd = this.parser.apply((StorageMetadata)md);
        Assert.assertEquals((String)rd.getName(), (String)"dir");
        Assert.assertEquals((String)rd.getProviderId(), (String)"dir/");
        Assert.assertEquals((Object)rd.getType(), (Object)StorageType.RELATIVE_PATH);
    }

    @Test
    public void test2() {
        MutableBlobMetadata md = (MutableBlobMetadata)this.blobMetadataProvider.get();
        md.setName("dir_$folder$");
        md.setId("dir_$folder$");
        StorageMetadata rd = this.parser.apply((StorageMetadata)md);
        Assert.assertEquals((String)rd.getName(), (String)"dir");
        Assert.assertEquals((String)rd.getProviderId(), (String)"dir_$folder$");
        Assert.assertEquals((Object)rd.getType(), (Object)StorageType.RELATIVE_PATH);
    }

    @Test
    public void testNoNameChange() {
        MutableBlobMetadata md = (MutableBlobMetadata)this.blobMetadataProvider.get();
        md.setName("dir");
        md.setId("dir");
        StorageMetadata rd = this.parser.apply((StorageMetadata)md);
        Assert.assertEquals((String)rd.getName(), (String)"dir");
        Assert.assertEquals((String)rd.getProviderId(), (String)"dir");
        Assert.assertEquals((Object)rd.getType(), (Object)StorageType.RELATIVE_PATH);
    }
}

