/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import jakarta.inject.Provider;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class ParseSystemAndUserMetadataFromHeadersTest {
    private ParseSystemAndUserMetadataFromHeaders parser;
    private Provider<MutableBlobMetadata> blobMetadataProvider = new Provider<MutableBlobMetadata>(){

        public MutableBlobMetadata get() {
            return new MutableBlobMetadataImpl();
        }
    };

    @BeforeTest
    void setUp() {
        this.parser = new ParseSystemAndUserMetadataFromHeaders(this.blobMetadataProvider, (DateService)new SimpleDateFormatDateService(), "prefix");
        this.parser.setName("key");
    }

    @Test
    public void testApplySetsName() {
        HttpResponse from = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).addHeader("Last-Modified", new String[]{"Wed, 09 Sep 2009 19:50:23 GMT"})).build();
        from.getPayload().getContentMetadata().setContentType("application/json");
        from.getPayload().getContentMetadata().setContentLength(Long.valueOf(100L));
        MutableBlobMetadata metadata = this.parser.apply(from);
        Assert.assertEquals((String)metadata.getName(), (String)"key");
    }

    @Test
    public void testNoContentOn204IsOk() {
        HttpResponse from = ((HttpResponse.Builder)HttpResponse.builder().statusCode(204).message("ok").addHeader("Last-Modified", new String[]{"Wed, 09 Sep 2009 19:50:23 GMT"})).build();
        this.parser.apply(from);
    }

    @Test
    public void testSetLastModified() {
        HttpResponse from = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).addHeader("Last-Modified", new String[]{"Wed, 09 Sep 2009 19:50:23 GMT"})).build();
        MutableBlobMetadata metadata = (MutableBlobMetadata)this.blobMetadataProvider.get();
        this.parser.parseLastModifiedOrThrowException(from, metadata);
        Assert.assertEquals((Object)metadata.getLastModified(), (Object)new SimpleDateFormatDateService().rfc822DateParse("Wed, 09 Sep 2009 19:50:23 GMT"));
    }

    @Test
    public void testSetLastModifiedIso8601() {
        HttpResponse from = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).addHeader("Last-Modified", new String[]{"2011-01-28T17:35:08.000Z"})).build();
        MutableBlobMetadata metadata = (MutableBlobMetadata)this.blobMetadataProvider.get();
        this.parser.parseLastModifiedOrThrowException(from, metadata);
        Assert.assertEquals((Object)metadata.getLastModified(), (Object)new SimpleDateFormatDateService().iso8601DateParse("2011-01-28T17:35:08.000Z"));
    }

    @Test(expectedExceptions={HttpException.class})
    public void testSetLastModifiedException() {
        HttpResponse from = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).build();
        MutableBlobMetadata metadata = (MutableBlobMetadata)this.blobMetadataProvider.get();
        this.parser.parseLastModifiedOrThrowException(from, metadata);
    }

    @Test
    public void testAddETagTo() {
        HttpResponse from = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).addHeader("ETag", new String[]{"0xfeb"})).build();
        MutableBlobMetadata metadata = (MutableBlobMetadata)this.blobMetadataProvider.get();
        this.parser.addETagTo(from, metadata);
        Assert.assertEquals((String)metadata.getETag(), (String)"0xfeb");
    }

    @Test
    public void testAddUserMetadataTo() {
        HttpResponse from = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).addHeader("prefixkey", new String[]{"value"})).build();
        MutableBlobMetadata metadata = (MutableBlobMetadata)this.blobMetadataProvider.get();
        this.parser.addUserMetadataTo(from, metadata);
        Assert.assertEquals((String)((String)metadata.getUserMetadata().get("key")), (String)"value");
    }
}

