/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.cluster;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRepositoryInfo {
    private static final Logger log = LoggerFactory.getLogger(ClusterRepositoryInfo.class);
    public static final String OAK_CLUSTERID_REPOSITORY_DESCRIPTOR_KEY = "oak.clusterid";
    public static final String CLUSTER_CONFIG_NODE = ":clusterConfig";
    public static final String CLUSTER_ID_PROP = ":clusterId";

    private ClusterRepositoryInfo() {
    }

    @Nullable
    public static String getOrCreateId(@NotNull NodeStore store) {
        Preconditions.checkNotNull((Object)store, (Object)"store is null");
        NodeState root = store.getRoot();
        NodeState node = root.getChildNode(CLUSTER_CONFIG_NODE);
        if (node.exists() && node.hasProperty(CLUSTER_ID_PROP)) {
            return (String)node.getProperty(CLUSTER_ID_PROP).getValue(Type.STRING);
        }
        NodeBuilder builder = root.builder();
        String newRandomClusterId = UUID.randomUUID().toString();
        builder.child(CLUSTER_CONFIG_NODE).setProperty(CLUSTER_ID_PROP, newRandomClusterId);
        try {
            store.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
            log.info("getOrCreateId: created a new clusterId=" + newRandomClusterId);
            return newRandomClusterId;
        }
        catch (CommitFailedException e) {
            root = store.getRoot();
            node = root.getChildNode(CLUSTER_CONFIG_NODE);
            if (node.exists() && node.hasProperty(CLUSTER_ID_PROP)) {
                return (String)node.getProperty(CLUSTER_ID_PROP).getValue(Type.STRING);
            }
            String path = "/:clusterConfig/:clusterId";
            log.error("getOrCreateId: both setting and then reading of " + path + "failed");
            throw new IllegalStateException("Both setting and then reading of " + path + " failed");
        }
    }

    @Nullable
    public static String getId(@NotNull NodeStore store) {
        Preconditions.checkNotNull((Object)store, (Object)"store is null");
        NodeState root = store.getRoot();
        NodeState node = root.getChildNode(CLUSTER_CONFIG_NODE);
        if (node.exists() && node.hasProperty(CLUSTER_ID_PROP)) {
            return (String)node.getProperty(CLUSTER_ID_PROP).getValue(Type.STRING);
        }
        return null;
    }
}

