/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.MultiPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

public class MultiGenericPropertyState
extends MultiPropertyState<String> {
    private final Type<?> type;

    public MultiGenericPropertyState(String name, Iterable<String> values, Type<?> type) {
        super(name, values);
        Preconditions.checkArgument((boolean)type.isArray());
        this.type = type;
    }

    public static PropertyState dateProperty(String name, Iterable<String> values) {
        return new MultiGenericPropertyState(name, values, Type.DATES);
    }

    public static PropertyState nameProperty(String name, Iterable<String> values) {
        return new MultiGenericPropertyState(name, values, Type.NAMES);
    }

    public static PropertyState pathProperty(String name, Iterable<String> values) {
        return new MultiGenericPropertyState(name, values, Type.PATHS);
    }

    public static PropertyState referenceProperty(String name, Iterable<String> values) {
        return new MultiGenericPropertyState(name, values, Type.REFERENCES);
    }

    public static PropertyState weakreferenceProperty(String name, Iterable<String> values) {
        return new MultiGenericPropertyState(name, values, Type.WEAKREFERENCES);
    }

    public static PropertyState uriProperty(String name, Iterable<String> values) {
        return new MultiGenericPropertyState(name, values, Type.URIS);
    }

    @Override
    public Conversions.Converter getConverter(String value) {
        return Conversions.convert(value, this.type.getBaseType());
    }

    public Type<?> getType() {
        return this.type;
    }
}

