/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.plugins.segment.SegmentGraph;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.file.FileAccess;
import org.apache.jackrabbit.oak.plugins.segment.file.TarEntry;
import org.apache.jackrabbit.oak.plugins.segment.file.TarEntryVisitor;
import org.apache.jackrabbit.oak.plugins.segment.file.TarWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TarReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TarReader.class);
    private static final Logger GC_LOG = LoggerFactory.getLogger((String)(TarReader.class.getName() + "-GC"));
    private static final int INDEX_MAGIC = 170937098;
    private static final Pattern NAME_PATTERN = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(\\.([0-9a-f]{8}))?(\\..*)?");
    private static final int BLOCK_SIZE = 512;
    private final File file;
    private final FileAccess access;
    private final ByteBuffer index;
    private volatile boolean closed;

    static int getEntrySize(int size) {
        return 512 + size + TarWriter.getPaddingSize(size);
    }

    static TarReader open(File file, boolean memoryMapping) throws IOException {
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open tar file " + file);
    }

    static TarReader open(Map<Character, File> files, boolean memoryMapping) throws IOException {
        TreeMap sorted = Maps.newTreeMap();
        sorted.putAll(files);
        ArrayList list = Lists.newArrayList(sorted.values());
        Collections.reverse(list);
        TarReader reader = TarReader.openFirstFileWithValidIndex(list, memoryMapping);
        if (reader != null) {
            return reader;
        }
        log.warn("Could not find a valid tar index in {}, recovering...", (Object)list);
        LinkedHashMap entries = Maps.newLinkedHashMap();
        for (File file : sorted.values()) {
            TarReader.collectFileEntries(file, entries, true);
        }
        File file = (File)sorted.values().iterator().next();
        TarReader.generateTarFile(entries, file);
        reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open recovered tar file " + file);
    }

    static TarReader openRO(Map<Character, File> files, boolean memoryMapping, boolean recover) throws IOException {
        File file = files.get(Collections.max(files.keySet()));
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
        if (reader != null) {
            return reader;
        }
        if (recover) {
            log.warn("Could not find a valid tar index in {}, recovering read-only", (Object)file);
            LinkedHashMap entries = Maps.newLinkedHashMap();
            TarReader.collectFileEntries(file, entries, false);
            file = TarReader.findAvailGen(file, ".ro.bak");
            TarReader.generateTarFile(entries, file);
            reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping);
            if (reader != null) {
                return reader;
            }
        }
        throw new IOException("Failed to open tar file " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectFileEntries(File file, LinkedHashMap<UUID, byte[]> entries, boolean backup) throws IOException {
        log.info("Recovering segments from tar file {}", (Object)file);
        try (RandomAccessFile access = new RandomAccessFile(file, "r");){
            TarReader.recoverEntries(file, access, entries);
        }
        catch (IOException e) {
            log.warn("Could not read tar file " + file + ", skipping...", (Throwable)e);
        }
        if (backup) {
            TarReader.backupSafely(file);
        }
    }

    private static void generateTarFile(LinkedHashMap<UUID, byte[]> entries, File file) throws IOException {
        log.info("Regenerating tar file " + file);
        TarWriter writer = new TarWriter(file);
        for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
            UUID uuid = entry.getKey();
            byte[] data = entry.getValue();
            writer.writeEntry(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), data, 0, data.length);
        }
        writer.close();
    }

    private static void backupSafely(File file) throws IOException {
        File backup = TarReader.findAvailGen(file, ".bak");
        log.info("Backing up " + file + " to " + backup.getName());
        if (!file.renameTo(backup)) {
            log.warn("Renaming failed, so using copy to backup {}", (Object)file);
            FileUtils.copyFile((File)file, (File)backup);
            if (!file.delete()) {
                throw new IOException("Could not remove broken tar file " + file);
            }
        }
    }

    private static File findAvailGen(File file, String ext) {
        File parent = file.getParentFile();
        String name = file.getName();
        File backup = new File(parent, name + ext);
        int i = 2;
        while (backup.exists()) {
            backup = new File(parent, name + "." + i + ext);
            ++i;
        }
        return backup;
    }

    /*
     * Exception decompiling
     */
    private static TarReader openFirstFileWithValidIndex(List<File> files, boolean memoryMapping) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 6[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ByteBuffer loadAndValidateIndex(RandomAccessFile file, String name) throws IOException {
        long length = file.length();
        if (length % 512L != 0L || length < 3072L || length > Integer.MAX_VALUE) {
            log.warn("Unexpected size {} of tar file {}", (Object)length, (Object)name);
            return null;
        }
        ByteBuffer meta = ByteBuffer.allocate(16);
        file.seek(length - 1024L - 16L);
        file.readFully(meta.array());
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170937098) {
            return null;
        }
        if (count < 1 || bytes < count * 24 + 16 || bytes % 512 != 0) {
            log.warn("Invalid index metadata in tar file {}", (Object)name);
            return null;
        }
        ByteBuffer index = ByteBuffer.allocate(count * 24);
        file.seek(length - 1024L - 16L - (long)(count * 24));
        file.readFully(index.array());
        index.mark();
        CRC32 checksum = new CRC32();
        long limit = length - 1024L - (long)bytes - 512L;
        long lastmsb = Long.MIN_VALUE;
        long lastlsb = Long.MIN_VALUE;
        byte[] entry = new byte[24];
        for (int i = 0; i < count; ++i) {
            index.get(entry);
            checksum.update(entry);
            ByteBuffer buffer = ByteBuffer.wrap(entry);
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int offset = buffer.getInt();
            int size = buffer.getInt();
            if (lastmsb > msb || lastmsb == msb && lastlsb > lsb) {
                log.warn("Incorrect index ordering in tar file {}", (Object)name);
                return null;
            }
            if (lastmsb == msb && lastlsb == lsb && i > 0) {
                log.warn("Duplicate index entry in tar file {}", (Object)name);
                return null;
            }
            if (offset < 0 || offset % 512 != 0) {
                log.warn("Invalid index entry offset in tar file {}", (Object)name);
                return null;
            }
            if (size < 1 || (long)(offset + size) > limit) {
                log.warn("Invalid index entry size in tar file {}", (Object)name);
                return null;
            }
            lastmsb = msb;
            lastlsb = lsb;
        }
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid index checksum in tar file {}", (Object)name);
            return null;
        }
        index.reset();
        return index;
    }

    private static void recoverEntries(File file, RandomAccessFile access, LinkedHashMap<UUID, byte[]> entries) throws IOException {
        byte[] header = new byte[512];
        while (access.getFilePointer() + 512L <= access.length()) {
            int i;
            access.readFully(header);
            int sum = 0;
            for (i = 0; i < 512; ++i) {
                sum += header[i] & 0xFF;
            }
            if (sum == 0 && access.getFilePointer() + 1024L == access.length()) {
                return;
            }
            for (i = 148; i < 156; ++i) {
                sum -= header[i] & 0xFF;
                sum += 32;
            }
            byte[] checkbytes = String.format("%06o\u0000 ", sum).getBytes(Charsets.UTF_8);
            for (int i2 = 0; i2 < checkbytes.length; ++i2) {
                if (checkbytes[i2] == header[148 + i2]) continue;
                log.warn("Invalid entry checksum at offset {} in tar file {}, skipping...", (Object)(access.getFilePointer() - 512L), (Object)file);
            }
            ByteBuffer buffer = ByteBuffer.wrap(header);
            String name = TarReader.readString(buffer, 100);
            buffer.position(124);
            int size = TarReader.readNumber(buffer, 12);
            if (access.getFilePointer() + (long)size > access.length()) {
                log.warn("Partial entry {} in tar file {}, ignoring...", (Object)name, (Object)file);
                return;
            }
            Matcher matcher = NAME_PATTERN.matcher(name);
            if (matcher.matches()) {
                UUID id = UUID.fromString(matcher.group(1));
                String checksum = matcher.group(3);
                if (checksum == null && entries.containsKey(id)) continue;
                byte[] data = new byte[size];
                access.readFully(data);
                long position = access.getFilePointer();
                long remainder = position % 512L;
                if (remainder != 0L) {
                    access.seek(position + (512L - remainder));
                }
                if (checksum != null) {
                    CRC32 crc = new CRC32();
                    crc.update(data);
                    if (crc.getValue() != Long.parseLong(checksum, 16)) {
                        log.warn("Checksum mismatch in entry {} of tar file {}, skipping...", (Object)name, (Object)file);
                        continue;
                    }
                }
                entries.put(id, data);
                continue;
            }
            if (name.equals(file.getName() + ".idx")) continue;
            log.warn("Unexpected entry {} in tar file {}, skipping...", (Object)name, (Object)file);
            long position = access.getFilePointer() + (long)size;
            long remainder = position % 512L;
            if (remainder != 0L) {
                position += 512L - remainder;
            }
            access.seek(position);
        }
    }

    private TarReader(File file, FileAccess access, ByteBuffer index) {
        this.file = file;
        this.access = access;
        this.index = index;
    }

    long size() {
        return this.file.length();
    }

    int count() {
        return this.index.capacity() / 24;
    }

    void accept(TarEntryVisitor visitor) {
        for (int position = this.index.position(); position < this.index.limit(); position += 24) {
            visitor.visit(this.index.getLong(position), this.index.getLong(position + 8), this.file, this.index.getInt(position + 16), this.index.getInt(position + 20));
        }
    }

    Set<UUID> getUUIDs() {
        HashSet uuids = Sets.newHashSetWithExpectedSize((int)(this.index.remaining() / 24));
        for (int position = this.index.position(); position < this.index.limit(); position += 24) {
            uuids.add(new UUID(this.index.getLong(position), this.index.getLong(position + 8)));
        }
        return uuids;
    }

    boolean containsEntry(long msb, long lsb) {
        return this.findEntry(msb, lsb) != -1;
    }

    ByteBuffer readEntry(long msb, long lsb) throws IOException {
        int position = this.findEntry(msb, lsb);
        if (position != -1) {
            return this.access.read(this.index.getInt(position + 16), this.index.getInt(position + 20));
        }
        return null;
    }

    private int findEntry(long msb, long lsb) {
        int lowIndex = 0;
        int highIndex = this.index.remaining() / 24 - 1;
        float lowValue = -9.223372E18f;
        float highValue = 9.223372E18f;
        float targetValue = msb;
        while (lowIndex <= highIndex) {
            int guessIndex = lowIndex + Math.round((float)(highIndex - lowIndex) * (targetValue - lowValue) / (highValue - lowValue));
            int position = this.index.position() + guessIndex * 24;
            long m = this.index.getLong(position);
            if (msb < m) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (msb > m) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            long l = this.index.getLong(position + 8);
            if (lsb < l) {
                highIndex = guessIndex - 1;
                highValue = m;
                continue;
            }
            if (lsb > l) {
                lowIndex = guessIndex + 1;
                lowValue = m;
                continue;
            }
            return position;
        }
        return -1;
    }

    @Nonnull
    private TarEntry[] getEntries() {
        TarEntry[] entries = new TarEntry[this.index.remaining() / 24];
        int position = this.index.position();
        int i = 0;
        while (position < this.index.limit()) {
            entries[i] = new TarEntry(this.index.getLong(position), this.index.getLong(position + 8), this.index.getInt(position + 16), this.index.getInt(position + 20));
            position += 24;
            ++i;
        }
        Arrays.sort(entries, TarEntry.OFFSET_ORDER);
        return entries;
    }

    @CheckForNull
    private List<UUID> getReferences(TarEntry entry, UUID id, Map<UUID, List<UUID>> graph) throws IOException {
        if (graph != null) {
            return graph.get(id);
        }
        ByteBuffer segment = this.access.read(entry.offset(), Math.min(entry.size(), 4096));
        int pos = segment.position();
        int refCount = segment.get(pos + 5) & 0xFF;
        int refEnd = pos + 16 * (refCount + 1);
        ArrayList refIds = Lists.newArrayList();
        for (int refPos = pos + 16; refPos < refEnd; refPos += 16) {
            refIds.add(new UUID(segment.getLong(refPos), segment.getLong(refPos + 8)));
        }
        return refIds;
    }

    public void traverseSegmentGraph(@Nonnull Set<UUID> roots, @Nonnull SegmentGraph.SegmentGraphVisitor visitor) throws IOException {
        Preconditions.checkNotNull(roots);
        Preconditions.checkNotNull((Object)visitor);
        Map<UUID, List<UUID>> graph = this.getGraph();
        TarEntry[] entries = this.getEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            TarEntry entry = entries[i];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (roots.remove(id) && SegmentId.isDataSegmentId(entry.lsb())) {
                List<UUID> refIds = this.getReferences(entry, id, graph);
                if (refIds != null) {
                    for (UUID refId : refIds) {
                        visitor.accept(id, refId);
                        roots.add(refId);
                    }
                    continue;
                }
                visitor.accept(id, null);
                continue;
            }
            visitor.accept(id, null);
        }
    }

    void calculateForwardReferences(Set<UUID> referencedIds) throws IOException {
        Map<UUID, List<UUID>> graph = this.getGraph();
        TarEntry[] entries = this.getEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            List<UUID> refIds;
            TarEntry entry = entries[i];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (!referencedIds.remove(id) || !SegmentId.isDataSegmentId(entry.lsb()) || (refIds = this.getReferences(entry, id, graph)) == null) continue;
            referencedIds.addAll(refIds);
        }
    }

    synchronized TarReader cleanup(Set<UUID> referencedIds, Set<UUID> removed) throws IOException {
        String name = this.file.getName();
        log.debug("Cleaning up {}", (Object)name);
        HashSet cleaned = Sets.newHashSet();
        Map<UUID, List<UUID>> graph = this.getGraph();
        TarEntry[] entries = this.getEntries();
        int size = 0;
        int count = 0;
        for (int i = entries.length - 1; i >= 0; --i) {
            List<UUID> refIds;
            TarEntry entry = entries[i];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (!referencedIds.remove(id)) {
                cleaned.add(id);
                entries[i] = null;
                continue;
            }
            size += TarReader.getEntrySize(entry.size());
            ++count;
            if (!SegmentId.isDataSegmentId(entry.lsb()) || (refIds = this.getReferences(entry, id, graph)) == null) continue;
            referencedIds.addAll(refIds);
        }
        size += TarReader.getEntrySize(24 * count + 16);
        size += 1024;
        if (count == 0) {
            log.debug("None of the entries of {} are referenceable.", (Object)name);
            removed.addAll(cleaned);
            this.logCleanedSegments(cleaned);
            return null;
        }
        if (size >= this.access.length() * 3 / 4 && graph != null) {
            log.debug("Not enough space savings. ({}/{}). Skipping clean up of {}", new Object[]{this.access.length() - size, this.access.length(), name});
            return this;
        }
        int pos = name.length() - "a.tar".length();
        char generation = name.charAt(pos);
        if (generation == 'z') {
            log.debug("No garbage collection after reaching generation z: {}", (Object)name);
            return this;
        }
        File newFile = new File(this.file.getParentFile(), name.substring(0, pos) + (char)(generation + '\u0001') + ".tar");
        log.debug("Writing new generation {}", (Object)newFile.getName());
        TarWriter writer = new TarWriter(newFile);
        for (TarEntry entry : entries) {
            if (entry == null) continue;
            byte[] data = new byte[entry.size()];
            this.access.read(entry.offset(), entry.size()).get(data);
            writer.writeEntry(entry.msb(), entry.lsb(), data, 0, entry.size());
        }
        writer.close();
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(newFile), this.access.isMemoryMapped());
        if (reader != null) {
            this.logCleanedSegments(cleaned);
            removed.addAll(cleaned);
            return reader;
        }
        log.warn("Failed to open cleaned up tar file {}", (Object)this.file);
        return this;
    }

    private void logCleanedSegments(Set<UUID> cleaned) {
        StringBuilder uuids = new StringBuilder();
        String newLine = System.getProperty("line.separator", "\n") + "        ";
        int c = 0;
        String sep = "";
        for (UUID uuid : cleaned) {
            uuids.append(sep);
            if (c++ % 4 == 0) {
                uuids.append(newLine);
            }
            uuids.append(uuid);
            sep = ", ";
        }
        GC_LOG.info("TarMK cleaned segments from {}: {}", (Object)this.file.getName(), (Object)uuids);
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.access.close();
    }

    Map<UUID, List<UUID>> getGraph() throws IOException {
        ByteBuffer graph = this.loadGraph();
        if (graph == null) {
            return null;
        }
        return TarReader.parseGraph(graph);
    }

    private ByteBuffer loadGraph() throws IOException {
        int pos = this.access.length() - 1024 - TarReader.getEntrySize(this.index.remaining());
        ByteBuffer meta = this.access.read(pos - 16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170936074) {
            return null;
        }
        if (count < 0 || bytes < count * 16 + 16 || 512 + bytes > pos) {
            log.warn("Invalid graph metadata in tar file {}", (Object)this.file);
            return null;
        }
        ByteBuffer graph = this.access.read(pos - bytes, bytes);
        byte[] b = new byte[bytes - 16];
        graph.mark();
        graph.get(b);
        graph.reset();
        CRC32 checksum = new CRC32();
        checksum.update(b);
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid graph checksum in tar file {}", (Object)this.file);
            return null;
        }
        return graph;
    }

    private static Map<UUID, List<UUID>> parseGraph(ByteBuffer graphByteBuffer) {
        int count = graphByteBuffer.getInt(graphByteBuffer.limit() - 12);
        ByteBuffer buffer = graphByteBuffer.duplicate();
        buffer.limit(graphByteBuffer.limit() - 16);
        ArrayList uuids = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            uuids.add(new UUID(buffer.getLong(), buffer.getLong()));
        }
        HashMap graph = Maps.newHashMap();
        while (buffer.hasRemaining()) {
            UUID uuid = (UUID)uuids.get(buffer.getInt());
            ArrayList list = Lists.newArrayList();
            int refid = buffer.getInt();
            while (refid != -1) {
                list.add(uuids.get(refid));
                refid = buffer.getInt();
            }
            graph.put(uuid, list);
        }
        return graph;
    }

    private static String readString(ByteBuffer buffer, int fieldSize) {
        int n;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        for (n = 0; n < fieldSize && b[n] != 0; ++n) {
        }
        return new String(b, 0, n, Charsets.UTF_8);
    }

    private static int readNumber(ByteBuffer buffer, int fieldSize) {
        int digit;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        int number = 0;
        for (int i = 0; i < fieldSize && 48 <= (digit = b[i] & 0xFF) && digit <= 55; ++i) {
            number = number * 8 + digit - 48;
        }
        return number;
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }
}

