/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.segment.ListRecord;
import org.apache.jackrabbit.oak.plugins.segment.MapEntry;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.Template;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

@Deprecated
public class SegmentNodeState
extends Record
implements NodeState {
    private volatile RecordId templateId = null;
    private volatile Template template = null;

    @Deprecated
    public SegmentNodeState(RecordId id) {
        super(id);
    }

    RecordId getTemplateId() {
        if (this.templateId == null) {
            this.templateId = this.getSegment().readRecordId(this.getOffset(0));
        }
        return this.templateId;
    }

    Template getTemplate() {
        if (this.template == null) {
            this.template = this.getSegment().readTemplate(this.getTemplateId());
        }
        return this.template;
    }

    MapRecord getChildNodeMap() {
        Segment segment = this.getSegment();
        return segment.readMap(segment.readRecordId(this.getOffset(0, 1)));
    }

    @Deprecated
    public boolean exists() {
        return true;
    }

    @Deprecated
    public long getPropertyCount() {
        Template template = this.getTemplate();
        long count = template.getPropertyTemplates().length;
        if (template.getPrimaryType() != null) {
            ++count;
        }
        if (template.getMixinTypes() != null) {
            ++count;
        }
        return count;
    }

    @Deprecated
    public boolean hasProperty(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name);
        Template template = this.getTemplate();
        if ("jcr:primaryType".equals(name)) {
            return template.getPrimaryType() != null;
        }
        if ("jcr:mixinTypes".equals(name)) {
            return template.getMixinTypes() != null;
        }
        return template.getPropertyTemplate(name) != null;
    }

    @CheckForNull
    @Deprecated
    public PropertyState getProperty(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name);
        Template template = this.getTemplate();
        PropertyState property = null;
        if ("jcr:primaryType".equals(name)) {
            property = template.getPrimaryType();
        } else if ("jcr:mixinTypes".equals(name)) {
            property = template.getMixinTypes();
        }
        if (property != null) {
            return property;
        }
        PropertyTemplate propertyTemplate = template.getPropertyTemplate(name);
        if (propertyTemplate != null) {
            Segment segment = this.getSegment();
            RecordId id = this.getSegment().getSegmentVersion().onOrAfter(SegmentVersion.V_11) ? this.getRecordIdV11(segment, template, propertyTemplate) : this.getRecordIdV10(segment, template, propertyTemplate);
            return new SegmentPropertyState(id, propertyTemplate);
        }
        return null;
    }

    private RecordId getRecordIdV10(Segment segment, Template template, PropertyTemplate propertyTemplate) {
        int ids = 1 + propertyTemplate.getIndex();
        if (template.getChildName() != Template.ZERO_CHILD_NODES) {
            ++ids;
        }
        return segment.readRecordId(this.getOffset(0, ids));
    }

    private RecordId getRecordIdV11(Segment segment, Template template, PropertyTemplate propertyTemplate) {
        int ids = 1;
        if (template.getChildName() != Template.ZERO_CHILD_NODES) {
            ++ids;
        }
        RecordId rid = segment.readRecordId(this.getOffset(0, ids));
        ListRecord pIds = new ListRecord(rid, template.getPropertyTemplates().length);
        return pIds.getEntry(propertyTemplate.getIndex());
    }

    @Nonnull
    @Deprecated
    public Iterable<PropertyState> getProperties() {
        ArrayList list;
        block6: {
            int ids;
            Segment segment;
            PropertyTemplate[] propertyTemplates;
            block5: {
                PropertyState mixinTypes;
                Template template = this.getTemplate();
                propertyTemplates = template.getPropertyTemplates();
                list = Lists.newArrayListWithCapacity((int)(propertyTemplates.length + 2));
                PropertyState primaryType = template.getPrimaryType();
                if (primaryType != null) {
                    list.add(primaryType);
                }
                if ((mixinTypes = template.getMixinTypes()) != null) {
                    list.add(mixinTypes);
                }
                segment = this.getSegment();
                ids = 1;
                if (template.getChildName() != Template.ZERO_CHILD_NODES) {
                    ++ids;
                }
                if (!segment.getSegmentVersion().onOrAfter(SegmentVersion.V_11)) break block5;
                if (propertyTemplates.length <= 0) break block6;
                ListRecord pIds = new ListRecord(segment.readRecordId(this.getOffset(0, ids)), propertyTemplates.length);
                for (int i = 0; i < propertyTemplates.length; ++i) {
                    RecordId propertyId = pIds.getEntry(i);
                    list.add(new SegmentPropertyState(propertyId, propertyTemplates[i]));
                }
                break block6;
            }
            for (int i = 0; i < propertyTemplates.length; ++i) {
                RecordId propertyId = segment.readRecordId(this.getOffset(0, ids++));
                list.add(new SegmentPropertyState(propertyId, propertyTemplates[i]));
            }
        }
        return list;
    }

    @Deprecated
    public boolean getBoolean(@Nonnull String name) {
        return Boolean.TRUE.toString().equals(this.getValueAsString(name, Type.BOOLEAN));
    }

    @Deprecated
    public long getLong(String name) {
        String value = this.getValueAsString(name, Type.LONG);
        if (value != null) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    @CheckForNull
    @Deprecated
    public String getString(String name) {
        return this.getValueAsString(name, Type.STRING);
    }

    @Nonnull
    @Deprecated
    public Iterable<String> getStrings(@Nonnull String name) {
        return this.getValuesAsStrings(name, Type.STRINGS);
    }

    @CheckForNull
    @Deprecated
    public String getName(@Nonnull String name) {
        return this.getValueAsString(name, Type.NAME);
    }

    @Nonnull
    @Deprecated
    public Iterable<String> getNames(@Nonnull String name) {
        return this.getValuesAsStrings(name, Type.NAMES);
    }

    @CheckForNull
    private String getValueAsString(String name, Type<?> type) {
        PropertyTemplate propertyTemplate;
        Preconditions.checkArgument((!type.isArray() ? 1 : 0) != 0);
        Template template = this.getTemplate();
        if ("jcr:primaryType".equals(name)) {
            PropertyState primary = template.getPrimaryType();
            if (primary != null) {
                if (type == Type.NAME) {
                    return (String)primary.getValue(Type.NAME);
                }
                return null;
            }
        } else if ("jcr:mixinTypes".equals(name) && template.getMixinTypes() != null) {
            return null;
        }
        if ((propertyTemplate = template.getPropertyTemplate(name)) == null || propertyTemplate.getType() != type) {
            return null;
        }
        Segment segment = this.getSegment();
        RecordId id = this.getSegment().getSegmentVersion().onOrAfter(SegmentVersion.V_11) ? this.getRecordIdV11(segment, template, propertyTemplate) : this.getRecordIdV10(segment, template, propertyTemplate);
        return Segment.readString(id);
    }

    @Nonnull
    private Iterable<String> getValuesAsStrings(String name, Type<?> type) {
        PropertyTemplate propertyTemplate;
        Preconditions.checkArgument((boolean)type.isArray());
        Template template = this.getTemplate();
        if ("jcr:mixinTypes".equals(name)) {
            PropertyState mixin = template.getMixinTypes();
            if (type == Type.NAMES && mixin != null) {
                return (Iterable)mixin.getValue(Type.NAMES);
            }
            if (type == Type.NAMES || mixin != null) {
                return Collections.emptyList();
            }
        } else if ("jcr:primaryType".equals(name) && template.getPrimaryType() != null) {
            return Collections.emptyList();
        }
        if ((propertyTemplate = template.getPropertyTemplate(name)) == null || propertyTemplate.getType() != type) {
            return Collections.emptyList();
        }
        Segment segment = this.getSegment();
        RecordId id = this.getSegment().getSegmentVersion().onOrAfter(SegmentVersion.V_11) ? this.getRecordIdV11(segment, template, propertyTemplate) : this.getRecordIdV10(segment, template, propertyTemplate);
        segment = id.getSegment();
        int size = segment.readInt(id.getOffset());
        if (size == 0) {
            return Collections.emptyList();
        }
        id = segment.readRecordId(id.getOffset() + 4);
        if (size == 1) {
            return Collections.singletonList(Segment.readString(id));
        }
        ArrayList values = Lists.newArrayListWithCapacity((int)size);
        ListRecord list = new ListRecord(id, size);
        for (RecordId value : list.getEntries()) {
            values.add(Segment.readString(value));
        }
        return values;
    }

    @Deprecated
    public long getChildNodeCount(long max) {
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return 0L;
        }
        if (childName == "") {
            return this.getChildNodeMap().size();
        }
        return 1L;
    }

    @Deprecated
    public boolean hasChildNode(@Nonnull String name) {
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return false;
        }
        if (childName == "") {
            return this.getChildNodeMap().getEntry(name) != null;
        }
        return childName.equals(name);
    }

    @Nonnull
    @Deprecated
    public NodeState getChildNode(@Nonnull String name) {
        String childName = this.getTemplate().getChildName();
        if (childName == "") {
            MapEntry child = this.getChildNodeMap().getEntry(name);
            if (child != null) {
                return child.getNodeState();
            }
        } else if (childName != Template.ZERO_CHILD_NODES && childName.equals(name)) {
            Segment segment = this.getSegment();
            RecordId childNodeId = segment.readRecordId(this.getOffset(0, 1));
            return new SegmentNodeState(childNodeId);
        }
        AbstractNodeState.checkValidName((String)name);
        return EmptyNodeState.MISSING_NODE;
    }

    @Nonnull
    @Deprecated
    public Iterable<String> getChildNodeNames() {
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return Collections.emptyList();
        }
        if (childName == "") {
            return this.getChildNodeMap().getKeys();
        }
        return Collections.singletonList(childName);
    }

    @Nonnull
    @Deprecated
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        String childName = this.getTemplate().getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            return Collections.emptyList();
        }
        if (childName == "") {
            return this.getChildNodeMap().getEntries();
        }
        Segment segment = this.getSegment();
        RecordId childNodeId = segment.readRecordId(this.getOffset(0, 1));
        return Collections.singletonList(new MemoryChildNodeEntry(childName, (NodeState)new SegmentNodeState(childNodeId)));
    }

    @Nonnull
    @Deprecated
    public SegmentNodeBuilder builder() {
        return new SegmentNodeBuilder(this);
    }

    @Deprecated
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (this == base || SegmentNodeState.fastEquals((Record)this, (Object)base)) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState((NodeState)this, (NodeStateDiff)diff);
        }
        if (!(base instanceof SegmentNodeState)) {
            return AbstractNodeState.compareAgainstBaseState((NodeState)this, (NodeState)base, (NodeStateDiff)diff);
        }
        SegmentNodeState that = (SegmentNodeState)base;
        if (that.wasCompactedTo(this)) {
            return true;
        }
        Template beforeTemplate = that.getTemplate();
        RecordId beforeId = that.getRecordId();
        Template afterTemplate = this.getTemplate();
        RecordId afterId = this.getRecordId();
        if (!SegmentNodeState.compareProperties(beforeTemplate.getPrimaryType(), afterTemplate.getPrimaryType(), diff)) {
            return false;
        }
        if (!SegmentNodeState.compareProperties(beforeTemplate.getMixinTypes(), afterTemplate.getMixinTypes(), diff)) {
            return false;
        }
        int beforeIndex = 0;
        int afterIndex = 0;
        PropertyTemplate[] beforeProperties = beforeTemplate.getPropertyTemplates();
        PropertyTemplate[] afterProperties = afterTemplate.getPropertyTemplates();
        while (beforeIndex < beforeProperties.length && afterIndex < afterProperties.length) {
            int d = Integer.valueOf(afterProperties[afterIndex].hashCode()).compareTo(beforeProperties[beforeIndex].hashCode());
            if (d == 0) {
                d = afterProperties[afterIndex].getName().compareTo(beforeProperties[beforeIndex].getName());
            }
            SegmentPropertyState beforeProperty = null;
            Object afterProperty = null;
            if (d < 0) {
                afterProperty = afterTemplate.getProperty(afterId, afterIndex++);
            } else if (d > 0) {
                beforeProperty = beforeTemplate.getProperty(beforeId, beforeIndex++);
            } else {
                afterProperty = afterTemplate.getProperty(afterId, afterIndex++);
                beforeProperty = beforeTemplate.getProperty(beforeId, beforeIndex++);
            }
            if (SegmentNodeState.compareProperties(beforeProperty, (PropertyState)afterProperty, diff)) continue;
            return false;
        }
        while (afterIndex < afterProperties.length) {
            if (diff.propertyAdded((PropertyState)afterTemplate.getProperty(afterId, afterIndex++))) continue;
            return false;
        }
        while (beforeIndex < beforeProperties.length) {
            SegmentPropertyState beforeProperty;
            if (diff.propertyDeleted((PropertyState)(beforeProperty = beforeTemplate.getProperty(beforeId, beforeIndex++)))) continue;
            return false;
        }
        String beforeChildName = beforeTemplate.getChildName();
        String afterChildName = afterTemplate.getChildName();
        if (afterChildName == Template.ZERO_CHILD_NODES) {
            if (beforeChildName != Template.ZERO_CHILD_NODES) {
                for (ChildNodeEntry childNodeEntry : beforeTemplate.getChildNodeEntries(beforeId)) {
                    if (diff.childNodeDeleted(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                    return false;
                }
            }
        } else if (afterChildName != "") {
            NodeState afterNode = afterTemplate.getChildNode(afterChildName, afterId);
            NodeState nodeState = beforeTemplate.getChildNode(afterChildName, beforeId);
            if (!nodeState.exists() ? !diff.childNodeAdded(afterChildName, afterNode) : !SegmentNodeState.fastEquals(afterNode, (Object)nodeState) && !diff.childNodeChanged(afterChildName, nodeState, afterNode)) {
                return false;
            }
            if (beforeChildName == "" || beforeChildName != Template.ZERO_CHILD_NODES && !nodeState.exists()) {
                for (ChildNodeEntry childNodeEntry : beforeTemplate.getChildNodeEntries(beforeId)) {
                    if (afterChildName.equals(childNodeEntry.getName()) || diff.childNodeDeleted(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                    return false;
                }
            }
        } else if (beforeChildName == Template.ZERO_CHILD_NODES) {
            for (ChildNodeEntry childNodeEntry : afterTemplate.getChildNodeEntries(afterId)) {
                if (diff.childNodeAdded(childNodeEntry.getName(), childNodeEntry.getNodeState())) continue;
                return false;
            }
        } else if (beforeChildName != "") {
            boolean beforeChildRemoved = true;
            NodeState nodeState = beforeTemplate.getChildNode(beforeChildName, beforeId);
            for (ChildNodeEntry childNodeEntry : afterTemplate.getChildNodeEntries(afterId)) {
                String childName = childNodeEntry.getName();
                NodeState afterChild = childNodeEntry.getNodeState();
                if (beforeChildName.equals(childName)) {
                    beforeChildRemoved = false;
                    if (SegmentNodeState.fastEquals(afterChild, (Object)nodeState) || diff.childNodeChanged(childName, nodeState, afterChild)) continue;
                    return false;
                }
                if (diff.childNodeAdded(childName, afterChild)) continue;
                return false;
            }
            if (beforeChildRemoved && !diff.childNodeDeleted(beforeChildName, nodeState)) {
                return false;
            }
        } else {
            MapRecord afterMap = afterTemplate.getChildNodeMap(afterId);
            MapRecord mapRecord = beforeTemplate.getChildNodeMap(beforeId);
            return afterMap.compare(mapRecord, diff);
        }
        return true;
    }

    private static boolean compareProperties(PropertyState before, PropertyState after, NodeStateDiff diff) {
        if (before == null) {
            return after == null || diff.propertyAdded(after);
        }
        if (after == null) {
            return diff.propertyDeleted(before);
        }
        return before.equals(after) || diff.propertyChanged(before, after);
    }

    @Override
    @Deprecated
    public boolean equals(Object object) {
        if (this == object || SegmentNodeState.fastEquals((Record)this, object)) {
            return true;
        }
        if (object instanceof SegmentNodeState) {
            SegmentNodeState that = (SegmentNodeState)object;
            Template template = this.getTemplate();
            return template.equals(that.getTemplate()) && template.compare(this.getRecordId(), that.getRecordId());
        }
        return object instanceof NodeState && AbstractNodeState.equals((NodeState)this, (NodeState)((NodeState)object));
    }

    @Override
    @Deprecated
    public String toString() {
        return AbstractNodeState.toString((NodeState)this);
    }
}

