/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.backup;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.segment.Compactor;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.plugins.segment.file.tooling.BasicReadOnlyBlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileStoreBackup {
    private static final Logger log = LoggerFactory.getLogger(FileStoreBackup.class);
    @Deprecated
    public static boolean USE_FAKE_BLOBSTORE = Boolean.getBoolean("oak.backup.UseFakeBlobStore");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void backup(NodeStore store, File destination) throws IOException, InvalidFileStoreVersionException {
        Preconditions.checkArgument((boolean)(store instanceof SegmentNodeStore));
        Stopwatch watch = Stopwatch.createStarted();
        NodeState current = ((SegmentNodeStore)store).getSuperRoot();
        FileStore.Builder builder = FileStore.builder(destination).withDefaultMemoryMapping();
        if (USE_FAKE_BLOBSTORE) {
            builder.withBlobStore(new BasicReadOnlyBlobStore());
        }
        try (FileStore backup = builder.build();){
            SegmentNodeState state = backup.getHead();
            Compactor compactor = new Compactor(backup.getTracker());
            compactor.setDeepCheckLargeBinaries(true);
            compactor.setContentEqualityCheck(true);
            SegmentNodeState after = compactor.compact(state, current, state);
            backup.setHead(state, after);
        }
        watch.stop();
        log.info("Backup finished in {}.", (Object)watch);
    }
}

