/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication;

import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMBean;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMonitor;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

public class LoginModuleStats
implements LoginModuleMBean,
LoginModuleMonitor {
    private final StatisticsProvider statisticsProvider;
    static final String LOGIN_ERRORS = "LOGIN_ERRORS";
    private final MeterStats loginErrors;

    public LoginModuleStats(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        this.loginErrors = statisticsProvider.getMeter(LOGIN_ERRORS, StatsOptions.DEFAULT);
    }

    @Override
    public void loginError() {
        this.loginErrors.mark();
    }

    @Override
    public long getLoginErrors() {
        return this.loginErrors.getCount();
    }

    @Override
    public CompositeData getLoginErrorsHistory() {
        return this.getTimeSeriesData(LOGIN_ERRORS, "Number of login errors.");
    }

    private CompositeData getTimeSeriesData(String name, String desc) {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(name), (String)desc);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }
}

