/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import com.google.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.OpenAuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.OpenAuthorizationConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenSecurityProvider
implements SecurityProvider {
    @Override
    @NotNull
    public ConfigurationParameters getParameters(@Nullable String name) {
        return ConfigurationParameters.EMPTY;
    }

    @Override
    @NotNull
    public Iterable<? extends SecurityConfiguration> getConfigurations() {
        return ImmutableList.of((Object)new OpenAuthenticationConfiguration(), (Object)new OpenAuthorizationConfiguration());
    }

    @Override
    @NotNull
    public <T> T getConfiguration(@NotNull Class<T> configClass) {
        if (AuthenticationConfiguration.class == configClass) {
            return (T)new OpenAuthenticationConfiguration();
        }
        if (AuthorizationConfiguration.class == configClass) {
            return (T)new OpenAuthorizationConfiguration();
        }
        throw new IllegalArgumentException("Unsupported security configuration class " + configClass);
    }
}

