/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.commons.webdav.ValueUtil;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.AbstractQValue;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.spi2davex.ValueLoader;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class QValueFactoryImpl
extends org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl {
    private static final Object DUMMY_VALUE = new Serializable(){
        private static final long serialVersionUID = -5667366239976271493L;
    };
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final ValueLoader loader;
    private final ValueFactory vf;

    public QValueFactoryImpl() {
        this(null, null);
    }

    QValueFactoryImpl(NamePathResolver resolver, ValueLoader loader) {
        this.loader = loader;
        this.vf = new ValueFactoryQImpl((QValueFactory)this, resolver);
    }

    QValue create(long length, String uri, int index) {
        if (this.loader == null) {
            throw new IllegalStateException();
        }
        return new BinaryQValue(length, uri, index);
    }

    int retrieveType(String uri) throws IOException, RepositoryException {
        return this.loader.loadType(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BinaryQValue
    extends AbstractQValue
    implements ValueLoader.Target {
        private static final long serialVersionUID = 2736654000266713469L;
        private static final int MAX_BUFFER_SIZE = 65536;
        private transient File file;
        private transient boolean temp;
        private byte[] buffer;
        private Map<String, String> headers;
        private final String uri;
        private final long length;
        private int index;
        private boolean initialized;

        private BinaryQValue(long length, String uri, int index) {
            super(DUMMY_VALUE, 2);
            this.index = -1;
            this.initialized = true;
            this.length = length;
            this.uri = uri;
            this.index = index;
            this.initialized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(InputStream in, boolean temp) throws IOException {
            byte[] spoolBuffer = new byte[8192];
            int len = 0;
            OutputStream out = null;
            File spoolFile = null;
            try {
                int read;
                while ((read = in.read(spoolBuffer)) > 0) {
                    if (out != null) {
                        out.write(spoolBuffer, 0, read);
                        len += read;
                        continue;
                    }
                    if (len + read > 65536) {
                        TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                        spoolFile = fileFactory.createTransientFile("bin", null, null);
                        out = new FileOutputStream(spoolFile);
                        out.write(this.buffer, 0, len);
                        out.write(spoolBuffer, 0, read);
                        this.buffer = null;
                        len += read;
                        continue;
                    }
                    if (this.buffer == null) {
                        this.buffer = EMPTY_BYTE_ARRAY;
                    }
                    byte[] newBuffer = new byte[len + read];
                    System.arraycopy(this.buffer, 0, newBuffer, 0, len);
                    System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                    this.buffer = newBuffer;
                    len += read;
                }
            }
            finally {
                in.close();
                if (out != null) {
                    out.close();
                }
            }
            if (spoolFile == null && this.buffer == null) {
                this.temp = false;
                this.buffer = EMPTY_BYTE_ARRAY;
            } else {
                this.file = spoolFile;
                this.temp = temp;
            }
            this.initialized = true;
        }

        public long getLength() {
            if (this.file != null) {
                if (this.file.exists()) {
                    return this.file.length();
                }
                return -1L;
            }
            if (this.buffer != null) {
                return this.buffer.length;
            }
            return this.length;
        }

        public InputStream getStream() throws RepositoryException {
            if (this.file == null && this.buffer == null) {
                try {
                    this.loadBinary();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            if (this.file != null) {
                try {
                    return new FileInputStream(this.file);
                }
                catch (FileNotFoundException fnfe) {
                    throw new RepositoryException("file backing binary value not found", (Throwable)fnfe);
                }
            }
            return new ByteArrayInputStream(this.buffer);
        }

        public Name getName() throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public Path getPath() throws RepositoryException {
            throw new UnsupportedOperationException();
        }

        public void discard() {
            if (!this.temp) {
                return;
            }
            if (this.file != null) {
                this.file.delete();
            } else if (this.buffer != null) {
                this.buffer = EMPTY_BYTE_ARRAY;
            }
        }

        @Override
        public void reset() {
            if (!this.temp) {
                return;
            }
            if (this.file != null) {
                this.file.delete();
            }
            this.file = null;
            this.buffer = null;
            this.initialized = false;
        }

        public String toString() {
            if (this.file != null) {
                return this.file.toString();
            }
            if (this.buffer != null) {
                return this.buffer.toString();
            }
            return super.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BinaryQValue) {
                BinaryQValue other = (BinaryQValue)obj;
                if (this.uri == null) {
                    return other.uri == null;
                }
                if (!this.uri.equals(other.uri)) {
                    return false;
                }
                if (!this.preInitialized() && !other.preInitialized()) {
                    return true;
                }
                try {
                    if (!this.preInitialized()) {
                        this.preInitialize(new String[]{"ETag", "Last-Modified"});
                    } else if (!other.preInitialized()) {
                        other.preInitialize(new String[]{"ETag", "Last-Modified"});
                    }
                }
                catch (RepositoryException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                if (this.headers != null && !this.headers.isEmpty()) {
                    if (this.containKey("ETag", this.headers, other.headers)) {
                        return this.equalValue("ETag", this.headers, other.headers);
                    }
                    if (this.containKey("Last-Modified", this.headers, other.headers) && !this.equalValue("Last-Modified", this.headers, other.headers)) {
                        return false;
                    }
                } else {
                    return (this.file == null ? other.file == null : this.file.equals(other.file)) && Arrays.equals(this.buffer, other.buffer);
                }
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }

        private synchronized void loadBinary() throws RepositoryException, IOException {
            if (this.uri == null) {
                throw new IllegalStateException();
            }
            QValueFactoryImpl.this.loader.loadBinary(this.uri, this.index, this);
        }

        private void preInitialize(String[] headerNames) throws IOException, RepositoryException {
            this.headers = QValueFactoryImpl.this.loader.loadHeaders(this.uri, headerNames);
            if (this.headers.isEmpty()) {
                this.loadBinary();
            }
        }

        private boolean preInitialized() {
            return this.initialized || this.headers != null;
        }

        private boolean equalValue(String key, Map<String, String> map1, Map<String, String> map2) {
            return map1.get(key).equals(map2.get(key));
        }

        private boolean containKey(String key, Map<String, String> map1, Map<String, String> map2) {
            return map1.containsKey(key) && map2.containsKey(key);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeBoolean(this.file != null);
            if (this.file != null) {
                int bytes;
                byte[] buffer = new byte[4096];
                FileInputStream stream = new FileInputStream(this.file);
                while ((bytes = ((InputStream)stream).read(buffer)) >= 0) {
                    if (bytes <= 0) continue;
                    out.writeInt(bytes);
                    out.write(buffer, 0, bytes);
                }
                out.writeInt(0);
                ((InputStream)stream).close();
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            boolean hasFile = in.readBoolean();
            if (hasFile) {
                this.file = File.createTempFile("binary-qvalue", "bin");
                FileOutputStream out = new FileOutputStream(this.file);
                byte[] buffer = new byte[4096];
                int bytes = in.readInt();
                while (bytes > 0) {
                    if (buffer.length < bytes) {
                        buffer = new byte[bytes];
                    }
                    in.readFully(buffer, 0, bytes);
                    ((OutputStream)out).write(buffer, 0, bytes);
                    bytes = in.readInt();
                }
                ((OutputStream)out).close();
            }
            this.temp = true;
        }

        @Override
        public void setStream(InputStream in) throws IOException {
            if (this.index == -1) {
                this.init(in, true);
            } else {
                try {
                    Document doc = DomUtil.parseDocument((InputStream)in);
                    Element prop = DomUtil.getChildElement((Node)doc, (String)"values", (Namespace)ItemResourceConstants.NAMESPACE);
                    DefaultDavProperty p = DefaultDavProperty.createFromXml((Element)prop);
                    Value[] jcrVs = ValueUtil.valuesFromXml((Object)p.getValue(), (int)2, (ValueFactory)QValueFactoryImpl.this.vf);
                    this.init(jcrVs[this.index].getStream(), true);
                }
                catch (RepositoryException e) {
                    throw new IOException(e.getMessage());
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }
}

