/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.spark3.internal.ReflectUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.Spark3ParsePartitionUtil$PartitionValues$;
import org.apache.spark.sql.execution.datasources.Spark3ParsePartitionUtil$TypedPartValue$;
import org.apache.spark.sql.execution.datasources.SparkParsePartitionUtil;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u001c9\u0001\u0015C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u00067\u0002!\t\u0005\u0018\u0004\u0007\u0003_\u0001\u0001)!\r\t\u0015\u0005}BA!f\u0001\n\u0003\t\t\u0005\u0003\u0006\u0002D\u0011\u0011\t\u0012)A\u0005\u0003\u0013A!\"!\u0012\u0005\u0005+\u0007I\u0011AA$\u0011)\tI\u0005\u0002B\tB\u0003%\u0011q\u0002\u0005\u0007/\u0012!\t!a\u0013\t\u0013\u0005UC!!A\u0005\u0002\u0005]\u0003\"CA/\tE\u0005I\u0011AA0\u0011%\t)\bBI\u0001\n\u0003\t9\bC\u0005\u0002|\u0011\t\t\u0011\"\u0011\u0002~!I\u0011\u0011\u0012\u0003\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003'#\u0011\u0011!C\u0001\u0003+C\u0011\"!)\u0005\u0003\u0003%\t%a)\t\u0013\u0005EF!!A\u0005\u0002\u0005M\u0006\"CA\\\t\u0005\u0005I\u0011IA]\u0011%\tY\fBA\u0001\n\u0003\ni\fC\u0005\u0002@\u0012\t\t\u0011\"\u0011\u0002B\u001eI\u0011Q\u0019\u0001\u0002\u0002#\u0005\u0011q\u0019\u0004\n\u0003_\u0001\u0011\u0011!E\u0001\u0003\u0013Daa\u0016\f\u0005\u0002\u0005]\u0007\"CA^-\u0005\u0005IQIA_\u0011%\tINFA\u0001\n\u0003\u000bY\u000eC\u0005\u0002bZ\t\t\u0011\"!\u0002d\u001a1\u0011Q\u001f\u0001A\u0003oD!\"!?\u001c\u0005+\u0007I\u0011AA~\u0011)\u0011ya\u0007B\tB\u0003%\u0011Q \u0005\u000b\u0005#Y\"Q3A\u0005\u0002\tM\u0001B\u0003B\f7\tE\t\u0015!\u0003\u0003\u0016!1qk\u0007C\u0001\u00053A\u0011\"!\u0016\u001c\u0003\u0003%\tA!\t\t\u0013\u0005u3$%A\u0005\u0002\t\u001d\u0002\"CA;7E\u0005I\u0011\u0001B\u0016\u0011%\tYhGA\u0001\n\u0003\ni\bC\u0005\u0002\nn\t\t\u0011\"\u0001\u0002\f\"I\u00111S\u000e\u0002\u0002\u0013\u0005!q\u0006\u0005\n\u0003C[\u0012\u0011!C!\u0003GC\u0011\"!-\u001c\u0003\u0003%\tAa\r\t\u0013\u0005]6$!A\u0005B\u0005e\u0006\"CA^7\u0005\u0005I\u0011IA_\u0011%\tylGA\u0001\n\u0003\u00129dB\u0005\u0003<\u0001\t\t\u0011#\u0001\u0003>\u0019I\u0011Q\u001f\u0001\u0002\u0002#\u0005!q\b\u0005\u0007/6\"\tAa\u0011\t\u0013\u0005mV&!A\u0005F\u0005u\u0006\"CAm[\u0005\u0005I\u0011\u0011B#\u0011%\t\t/LA\u0001\n\u0003\u0013Y\u0005\u0003\u0004\\\u0001\u0011%!1\u000b\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u00119\u000b\u0001C\u0005\u0005SCqAa.\u0001\t\u0003\u0011I\fC\u0004\u0003D\u0002!IA!2\u00031M\u0003\u0018M]64!\u0006\u00148/\u001a)beRLG/[8o+RLGN\u0003\u0002:u\u0005YA-\u0019;bg>,(oY3t\u0015\tYD(A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QHP\u0001\u0004gFd'BA A\u0003\u0015\u0019\b/\u0019:l\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\u0004\u0001M\u0019\u0001A\u0012'\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\r\u0005s\u0017PU3g!\tie*D\u00019\u0013\ty\u0005HA\fTa\u0006\u00148\u000eU1sg\u0016\u0004\u0016M\u001d;ji&|g.\u0016;jY\u0006!1m\u001c8g!\t\u0011V+D\u0001T\u0015\t!F(\u0001\u0005j]R,'O\\1m\u0013\t16KA\u0004T#2\u001buN\u001c4\u0002\rqJg.\u001b;?)\tI&\f\u0005\u0002N\u0001!)\u0001K\u0001a\u0001#\u0006q\u0001/\u0019:tKB\u000b'\u000f^5uS>tGcB/d[J|\u00181\u0004\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Ar\n\u0001bY1uC2L8\u000f^\u0005\u0003E~\u00131\"\u00138uKJt\u0017\r\u001c*po\")Am\u0001a\u0001K\u0006!\u0001/\u0019;i!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0002gg*\u0011!\u000eQ\u0001\u0007Q\u0006$wn\u001c9\n\u00051<'\u0001\u0002)bi\"DQA\\\u0002A\u0002=\fQ\u0002^=qK&sg-\u001a:f]\u000e,\u0007CA$q\u0013\t\t\bJA\u0004C_>dW-\u00198\t\u000bM\u001c\u0001\u0019\u0001;\u0002\u0013\t\f7/\u001a)bi\"\u001c\bcA;}K:\u0011aO\u001f\t\u0003o\"k\u0011\u0001\u001f\u0006\u0003s\u0012\u000ba\u0001\u0010:p_Rt\u0014BA>I\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0004'\u0016$(BA>I\u0011\u001d\t\ta\u0001a\u0001\u0003\u0007\ta#^:feN\u0003XmY5gS\u0016$G)\u0019;b)f\u0004Xm\u001d\t\bk\u0006\u0015\u0011\u0011BA\b\u0013\r\t9A \u0002\u0004\u001b\u0006\u0004\bcA;\u0002\f%\u0019\u0011Q\u0002@\u0003\rM#(/\u001b8h!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000by\u0005)A/\u001f9fg&!\u0011\u0011DA\n\u0005!!\u0015\r^1UsB,\u0007bBA\u000f\u0007\u0001\u0007\u0011qD\u0001\ti&lWMW8oKB!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012\u0001B;uS2T!!!\u000b\u0002\t)\fg/Y\u0005\u0005\u0003[\t\u0019C\u0001\u0005US6,'l\u001c8f\u00059!\u0016\u0010]3e!\u0006\u0014HOV1mk\u0016\u001cb\u0001\u0002$\u00024\u0005e\u0002cA$\u00026%\u0019\u0011q\u0007%\u0003\u000fA\u0013x\u000eZ;diB\u0019q)a\u000f\n\u0007\u0005u\u0002J\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003wC2,X-\u0006\u0002\u0002\n\u00051a/\u00197vK\u0002\n\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u001f\t\u0011\u0002Z1uCRK\b/\u001a\u0011\u0015\r\u00055\u0013\u0011KA*!\r\ty\u0005B\u0007\u0002\u0001!9\u0011qH\u0005A\u0002\u0005%\u0001bBA#\u0013\u0001\u0007\u0011qB\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002N\u0005e\u00131\f\u0005\n\u0003\u007fQ\u0001\u0013!a\u0001\u0003\u0013A\u0011\"!\u0012\u000b!\u0003\u0005\r!a\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\r\u0016\u0005\u0003\u0013\t\u0019g\u000b\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014!C;oG\",7m[3e\u0015\r\ty\u0007S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA:\u0003S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u001f+\t\u0005=\u00111M\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\t\u0005\u0015\u0015qE\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u000e\u0005\r\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAG!\r9\u0015qR\u0005\u0004\u0003#C%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAL\u0003;\u00032aRAM\u0013\r\tY\n\u0013\u0002\u0004\u0003:L\b\"CAP\u001f\u0005\u0005\t\u0019AAG\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0015\t\u0007\u0003O\u000bi+a&\u000e\u0005\u0005%&bAAV\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0016\u0011\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002p\u0003kC\u0011\"a(\u0012\u0003\u0003\u0005\r!a&\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a \u0002\r\u0015\fX/\u00197t)\ry\u00171\u0019\u0005\n\u0003?#\u0012\u0011!a\u0001\u0003/\u000ba\u0002V=qK\u0012\u0004\u0016M\u001d;WC2,X\rE\u0002\u0002PY\u0019RAFAf\u0003s\u0001\"\"!4\u0002T\u0006%\u0011qBA'\u001b\t\tyMC\u0002\u0002R\"\u000bqA];oi&lW-\u0003\u0003\u0002V\u0006='!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011qY\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u001b\ni.a8\t\u000f\u0005}\u0012\u00041\u0001\u0002\n!9\u0011QI\rA\u0002\u0005=\u0011aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\f\t\u0010E\u0003H\u0003O\fY/C\u0002\u0002j\"\u0013aa\u00149uS>t\u0007cB$\u0002n\u0006%\u0011qB\u0005\u0004\u0003_D%A\u0002+va2,'\u0007C\u0005\u0002tj\t\t\u00111\u0001\u0002N\u0005\u0019\u0001\u0010\n\u0019\u0003\u001fA\u000b'\u000f^5uS>tg+\u00197vKN\u001cba\u0007$\u00024\u0005e\u0012aC2pYVlgNT1nKN,\"!!@\u0011\r\u0005}(\u0011BA\u0005\u001d\u0011\u0011\tA!\u0002\u000f\u0007]\u0014\u0019!C\u0001J\u0013\r\u00119\u0001S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YA!\u0004\u0003\u0007M+\u0017OC\u0002\u0003\b!\u000bAbY8mk6tg*Y7fg\u0002\n1\u0002^=qK\u00124\u0016\r\\;fgV\u0011!Q\u0003\t\u0007\u0003\u007f\u0014I!!\u0014\u0002\u0019QL\b/\u001a3WC2,Xm\u001d\u0011\u0015\r\tm!Q\u0004B\u0010!\r\tye\u0007\u0005\b\u0003s\u0004\u0003\u0019AA\u007f\u0011\u001d\u0011\t\u0002\ta\u0001\u0005+!bAa\u0007\u0003$\t\u0015\u0002\"CA}CA\u0005\t\u0019AA\u007f\u0011%\u0011\t\"\tI\u0001\u0002\u0004\u0011)\"\u0006\u0002\u0003*)\"\u0011Q`A2+\t\u0011iC\u000b\u0003\u0003\u0016\u0005\rD\u0003BAL\u0005cA\u0011\"a('\u0003\u0003\u0005\r!!$\u0015\u0007=\u0014)\u0004C\u0005\u0002 \"\n\t\u00111\u0001\u0002\u0018R\u0019qN!\u000f\t\u0013\u0005}5&!AA\u0002\u0005]\u0015a\u0004)beRLG/[8o-\u0006dW/Z:\u0011\u0007\u0005=SfE\u0003.\u0005\u0003\nI\u0004\u0005\u0006\u0002N\u0006M\u0017Q B\u000b\u00057!\"A!\u0010\u0015\r\tm!q\tB%\u0011\u001d\tI\u0010\ra\u0001\u0003{DqA!\u00051\u0001\u0004\u0011)\u0002\u0006\u0003\u0003N\tE\u0003#B$\u0002h\n=\u0003cB$\u0002n\u0006u(Q\u0003\u0005\n\u0003g\f\u0014\u0011!a\u0001\u00057!\"C!\u0016\u0003\\\tu#q\fB1\u0005G\u00129Ga\u001e\u0003\u0006B9q)!<\u0003X\te\u0003#B$\u0002h\nm\u0001\u0003B$\u0002h\u0016DQ\u0001\u001a\u001aA\u0002\u0015DQA\u001c\u001aA\u0002=DQa\u001d\u001aA\u0002QDq!!\u00013\u0001\u0004\t\u0019\u0001\u0003\u0004\u0003fI\u0002\ra\\\u0001\u0019m\u0006d\u0017\u000eZ1uKB\u000b'\u000f^5uS>t7i\u001c7v[:\u001c\bb\u0002B5e\u0001\u0007!1N\u0001\u0007u>tW-\u00133\u0011\t\t5$1O\u0007\u0003\u0005_RAA!\u001d\u0002(\u0005!A/[7f\u0013\u0011\u0011)Ha\u001c\u0003\ri{g.Z%e\u0011\u001d\u0011IH\ra\u0001\u0005w\nQ\u0002Z1uK\u001a{'/\\1ui\u0016\u0014\b\u0003\u0002B?\u0005\u0003k!Aa \u000b\u0007\u0005\u0015r,\u0003\u0003\u0003\u0004\n}$!\u0004#bi\u00164uN]7biR,'\u000fC\u0004\u0003\bJ\u0002\rA!#\u0002%QLW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\t\u0005\u0005{\u0012Y)\u0003\u0003\u0003\u000e\n}$A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\fA\u0003]1sg\u0016\u0004\u0016M\u001d;ji&|gnQ8mk6tG\u0003\u0005BJ\u0005/\u0013YJ!(\u0003 \n\u0005&1\u0015BS!\u00159\u0015q\u001dBK!\u001d9\u0015Q^A\u0005\u0003\u001bBqA!'4\u0001\u0004\tI!\u0001\u0006d_2,XN\\*qK\u000eDQA\\\u001aA\u0002=Dq!!\u00014\u0001\u0004\t\u0019\u0001\u0003\u0004\u0003fM\u0002\ra\u001c\u0005\b\u0005S\u001a\u0004\u0019\u0001B6\u0011\u001d\u0011Ih\ra\u0001\u0005wBqAa\"4\u0001\u0004\u0011I)A\rj]\u001a,'\u000fU1si&$\u0018n\u001c8D_2,XN\u001c,bYV,G\u0003DA\b\u0005W\u0013yK!-\u00034\nU\u0006b\u0002BWi\u0001\u0007\u0011\u0011B\u0001\u0004e\u0006<\b\"\u000285\u0001\u0004y\u0007b\u0002B5i\u0001\u0007!1\u000e\u0005\b\u0005s\"\u0004\u0019\u0001B>\u0011\u001d\u00119\t\u000ea\u0001\u0005\u0013\u000b!dY1tiB\u000b'\u000f\u001e,bYV,Gk\u001c#fg&\u0014X\r\u001a+za\u0016$\u0002\"a&\u0003<\n}&\u0011\u0019\u0005\b\u0005{+\u0004\u0019AA\b\u0003-!Wm]5sK\u0012$\u0016\u0010]3\t\u000f\u0005}R\u00071\u0001\u0002\n!9!\u0011N\u001bA\u0002\t-\u0014a\u00034s_6$UmY5nC2$BAa2\u0003NB!\u0011\u0011\u0003Be\u0013\u0011\u0011Y-a\u0005\u0003\u0017\u0011+7-[7bYRK\b/\u001a\u0005\b\u0005\u001f4\u0004\u0019\u0001Bi\u0003\u0005!\u0007\u0003BA\t\u0005'LAA!6\u0002\u0014\t9A)Z2j[\u0006d\u0007")
public class Spark3ParsePartitionUtil
implements SparkParsePartitionUtil {
    private volatile Spark3ParsePartitionUtil$TypedPartValue$ TypedPartValue$module;
    private volatile Spark3ParsePartitionUtil$PartitionValues$ PartitionValues$module;
    private final SQLConf conf;

    public Spark3ParsePartitionUtil$TypedPartValue$ TypedPartValue() {
        if (this.TypedPartValue$module == null) {
            this.TypedPartValue$lzycompute$1();
        }
        return this.TypedPartValue$module;
    }

    public Spark3ParsePartitionUtil$PartitionValues$ PartitionValues() {
        if (this.PartitionValues$module == null) {
            this.PartitionValues$lzycompute$1();
        }
        return this.PartitionValues$module;
    }

    public InternalRow parsePartition(Path path, boolean typeInference, Set<Path> basePaths, Map<String, DataType> userSpecifiedDataTypes, TimeZone timeZone) {
        Option partitionValues;
        DateFormatter dateFormatter = ReflectUtil.getDateFormatter(timeZone.toZoneId());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(PartitioningUtils$.MODULE$.timestampPartitionPattern(), timeZone.toZoneId(), true);
        Tuple2<Option<PartitionValues>, Option<Path>> tuple2 = this.parsePartition(path, typeInference, basePaths, userSpecifiedDataTypes, this.conf.validatePartitionColumns(), timeZone.toZoneId(), dateFormatter, timestampFormatter);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = partitionValues = (Option)tuple2._1();
        Option partitionValues2 = option;
        return (InternalRow)partitionValues2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq<String> seq;
            Seq<TypedPartValue> typedValues;
            block3: {
                PartitionValues partitionValues;
                block2: {
                    partitionValues = x0$1;
                    if (partitionValues == null) break block2;
                    Seq<String> columnNames = partitionValues.columnNames();
                    typedValues = partitionValues.typedValues();
                    if (columnNames == null) break block2;
                    seq = columnNames;
                    if (typedValues != null) break block3;
                }
                throw new MatchError((Object)partitionValues);
            }
            Seq<TypedPartValue> seq2 = typedValues;
            Seq rowValues = (Seq)((TraversableLike)seq.zip(seq2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Object object;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String columnName = (String)tuple2._1();
                    TypedPartValue typedValue = (TypedPartValue)tuple2._2();
                    try {
                        object = this.castPartValueToDesiredType(typedValue.dataType(), typedValue.value(), timeZone.toZoneId());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            if ($this.conf.validatePartitionColumns()) {
                                throw new RuntimeException(new StringBuilder(53).append("Failed to cast value `").append(typedValue.value()).append("` to ").append("`").append(typedValue.dataType()).append("` for partition column `").append(columnName).append("`").toString());
                            }
                        } else {
                            throw throwable;
                        }
                        Object var4_9 = null;
                        object = var4_9;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Object object2 = object;
                return object2;
            }, Seq$.MODULE$.canBuildFrom());
            InternalRow internalRow = InternalRow$.MODULE$.fromSeq(rowValues);
            return internalRow;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> InternalRow$.MODULE$.empty());
    }

    private Tuple2<Option<PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Tuple2 tuple2;
        ArrayBuffer columns = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (!finished) {
            String string = currentPath.getName().toLowerCase(Locale.ROOT);
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, TypedPartValue>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference, userSpecifiedDataTypes, validatePartitionColumns, zoneId, dateFormatter, timestampFormatter);
            maybeColumn.foreach((Function1 & Serializable & scala.Serializable)x$1 -> columns.$plus$eq(x$1));
            finished = maybeColumn.isEmpty() && !columns.isEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
        if (columns.isEmpty()) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
        } else {
            Tuple2 tuple22 = ((GenericTraversableTemplate)columns.reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            ArrayBuffer columnNames = (ArrayBuffer)tuple22._1();
            ArrayBuffer values = (ArrayBuffer)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)columnNames, (Object)values);
            Tuple2 tuple24 = tuple23;
            ArrayBuffer columnNames2 = (ArrayBuffer)tuple24._1();
            ArrayBuffer values2 = (ArrayBuffer)tuple24._2();
            tuple2 = new Tuple2((Object)new Some((Object)new PartitionValues(this, (Seq<String>)columnNames2, (Seq<TypedPartValue>)values2)), (Object)new Some((Object)currentPath));
        }
        return tuple2;
    }

    private Option<Tuple2<String, TypedPartValue>> parsePartitionColumn(String columnSpec, boolean typeInference, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        None$ none$;
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            none$ = None$.MODULE$;
        } else {
            String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName((String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).take(equalSignIndex));
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(columnName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Empty partition column name in '").append(columnSpec).append("'").toString());
            String rawColumnValue = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).drop(equalSignIndex + 1);
            Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(rawColumnValue)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Empty partition column value in '").append(columnSpec).append("'").toString());
            DataType dataType = userSpecifiedDataTypes.contains((Object)columnName) ? (DataType)userSpecifiedDataTypes.apply((Object)columnName) : this.inferPartitionColumnValue(rawColumnValue, typeInference, zoneId, dateFormatter, timestampFormatter);
            none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new TypedPartValue(this, rawColumnValue, dataType)));
        }
        return none$;
    }

    private DataType inferPartitionColumnValue(String raw, boolean typeInference, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Object object;
        Try decimalTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = new BigDecimal(raw);
            Predef$.MODULE$.require(bigDecimal.scale() <= 0);
            return this.fromDecimal(Decimal$.MODULE$.apply(bigDecimal));
        });
        Try dateTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            dateFormatter.parse(raw);
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)raw), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()));
            InternalRow x$1 = qual$1.eval$default$1();
            Object dateValue = qual$1.eval(x$1);
            Predef$.MODULE$.require(dateValue != null);
            return DateType$.MODULE$;
        });
        Try timestampTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String unescapedRaw = ExternalCatalogUtils$.MODULE$.unescapePathName(raw);
            TimestampType$ timestampType = TimestampType$.MODULE$;
            timestampFormatter.parse(unescapedRaw);
            Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)unescapedRaw), (DataType)timestampType, (Option)new Some((Object)zoneId.getId()));
            InternalRow x$2 = qual$2.eval$default$1();
            Object timestampValue = qual$2.eval(x$2);
            Predef$.MODULE$.require(timestampValue != null);
            return timestampType;
        });
        if (typeInference) {
            object = (DataType)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Integer.parseInt(raw);
                return IntegerType$.MODULE$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Long.parseLong(raw);
                return LongType$.MODULE$;
            })).orElse((Function0 & Serializable & scala.Serializable)() -> decimalTry).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Double.parseDouble(raw);
                return DoubleType$.MODULE$;
            })).orElse((Function0 & Serializable & scala.Serializable)() -> timestampTry).orElse((Function0 & Serializable & scala.Serializable)() -> dateTry).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String string = raw;
                String string2 = "__HIVE_DEFAULT_PARTITION__";
                return !(string != null ? !string.equals(string2) : string2 != null) ? NullType$.MODULE$ : StringType$.MODULE$;
            });
        } else {
            String string = raw;
            String string2 = "__HIVE_DEFAULT_PARTITION__";
            object = !(string != null ? !string.equals(string2) : string2 != null) ? NullType$.MODULE$ : StringType$.MODULE$;
        }
        return object;
    }

    public Object castPartValueToDesiredType(DataType desiredType, String value, ZoneId zoneId) {
        Object object;
        DataType dataType = desiredType;
        String string = value;
        String string2 = "__HIVE_DEFAULT_PARTITION__";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = null;
        } else if (NullType$.MODULE$.equals(dataType)) {
            object = null;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToBoolean((boolean)Boolean.parseBoolean(value));
        } else if (StringType$.MODULE$.equals(dataType)) {
            object = UTF8String.fromString((String)ExternalCatalogUtils$.MODULE$.unescapePathName(value));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToInteger((int)Integer.parseInt(value));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToLong((long)Long.parseLong(value));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = BoxesRunTime.boxToDouble((double)Double.parseDouble(value));
        } else if (dataType instanceof DecimalType) {
            object = Literal$.MODULE$.apply((Object)new BigDecimal(value)).value();
        } else if (DateType$.MODULE$.equals(dataType)) {
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()));
            InternalRow x$1 = qual$1.eval$default$1();
            object = qual$1.eval(x$1);
        } else if (dataType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)dataType;
            object = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(value)), (DataType)timestampType, (Option)new Some((Object)zoneId.getId()));
                InternalRow x$2 = qual$2.eval$default$1();
                return qual$2.eval(x$2);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Cast qual$3 = new Cast((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId())), (DataType)timestampType, Cast$.MODULE$.apply$default$3());
                InternalRow x$3 = qual$3.eval$default$1();
                return qual$3.eval(x$3);
            });
        } else {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dataType).toString());
        }
        return object;
    }

    private DecimalType fromDecimal(Decimal d) {
        return new DecimalType(d.precision(), d.scale());
    }

    private final void TypedPartValue$lzycompute$1() {
        Spark3ParsePartitionUtil spark3ParsePartitionUtil = this;
        synchronized (spark3ParsePartitionUtil) {
            if (this.TypedPartValue$module == null) {
                this.TypedPartValue$module = new Spark3ParsePartitionUtil$TypedPartValue$(this);
            }
        }
    }

    private final void PartitionValues$lzycompute$1() {
        Spark3ParsePartitionUtil spark3ParsePartitionUtil = this;
        synchronized (spark3ParsePartitionUtil) {
            if (this.PartitionValues$module == null) {
                this.PartitionValues$module = new Spark3ParsePartitionUtil$PartitionValues$(this);
            }
        }
    }

    public Spark3ParsePartitionUtil(SQLConf conf) {
        this.conf = conf;
    }

    public class PartitionValues
    implements Product,
    scala.Serializable {
        private final Seq<String> columnNames;
        private final Seq<TypedPartValue> typedValues;
        public final /* synthetic */ Spark3ParsePartitionUtil $outer;

        public Seq<String> columnNames() {
            return this.columnNames;
        }

        public Seq<TypedPartValue> typedValues() {
            return this.typedValues;
        }

        public PartitionValues copy(Seq<String> columnNames, Seq<TypedPartValue> typedValues) {
            return new PartitionValues(this.org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$PartitionValues$$$outer(), columnNames, typedValues);
        }

        public Seq<String> copy$default$1() {
            return this.columnNames();
        }

        public Seq<TypedPartValue> copy$default$2() {
            return this.typedValues();
        }

        public String productPrefix() {
            return "PartitionValues";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.columnNames();
                    break;
                }
                case 1: {
                    object = this.typedValues();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartitionValues;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartitionValues)) return false;
            if (((PartitionValues)object).org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$PartitionValues$$$outer() != this.org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$PartitionValues$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            PartitionValues partitionValues = (PartitionValues)x$1;
            Seq<String> seq = this.columnNames();
            Seq<String> seq2 = partitionValues.columnNames();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<TypedPartValue> seq3 = this.typedValues();
            Seq<TypedPartValue> seq4 = partitionValues.typedValues();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            if (!partitionValues.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Spark3ParsePartitionUtil org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$PartitionValues$$$outer() {
            return this.$outer;
        }

        public PartitionValues(Spark3ParsePartitionUtil $outer, Seq<String> columnNames, Seq<TypedPartValue> typedValues) {
            this.columnNames = columnNames;
            this.typedValues = typedValues;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            Predef$.MODULE$.require(columnNames.size() == typedValues.size());
        }
    }

    public class TypedPartValue
    implements Product,
    scala.Serializable {
        private final String value;
        private final DataType dataType;
        public final /* synthetic */ Spark3ParsePartitionUtil $outer;

        public String value() {
            return this.value;
        }

        public DataType dataType() {
            return this.dataType;
        }

        public TypedPartValue copy(String value, DataType dataType) {
            return new TypedPartValue(this.org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$TypedPartValue$$$outer(), value, dataType);
        }

        public String copy$default$1() {
            return this.value();
        }

        public DataType copy$default$2() {
            return this.dataType();
        }

        public String productPrefix() {
            return "TypedPartValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.value();
                    break;
                }
                case 1: {
                    string = this.dataType();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TypedPartValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TypedPartValue)) return false;
            if (((TypedPartValue)object).org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$TypedPartValue$$$outer() != this.org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$TypedPartValue$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TypedPartValue typedPartValue = (TypedPartValue)x$1;
            String string = this.value();
            String string2 = typedPartValue.value();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            DataType dataType = this.dataType();
            DataType dataType2 = typedPartValue.dataType();
            if (dataType == null) {
                if (dataType2 != null) {
                    return false;
                }
            } else if (!dataType.equals(dataType2)) return false;
            if (!typedPartValue.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Spark3ParsePartitionUtil org$apache$spark$sql$execution$datasources$Spark3ParsePartitionUtil$TypedPartValue$$$outer() {
            return this.$outer;
        }

        public TypedPartValue(Spark3ParsePartitionUtil $outer, String value, DataType dataType) {
            this.value = value;
            this.dataType = dataType;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

