/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark3.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.DataSourceInternalWriterHelper;
import org.apache.hudi.spark3.internal.HoodieBulkInsertDataInternalWriterFactory;
import org.apache.hudi.spark3.internal.HoodieWriterCommitMessage;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;

public class HoodieDataSourceInternalBatchWrite
implements BatchWrite {
    private final String instantTime;
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final boolean arePartitionRecordsSorted;
    private final boolean populateMetaFields;
    private final DataSourceInternalWriterHelper dataSourceInternalWriterHelper;
    private Map<String, String> extraMetadata = new HashMap<String, String>();

    public HoodieDataSourceInternalBatchWrite(String instantTime, HoodieWriteConfig writeConfig, StructType structType, SparkSession jss, Configuration hadoopConfiguration, Map<String, String> properties, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this.instantTime = instantTime;
        this.writeConfig = writeConfig;
        this.structType = structType;
        this.populateMetaFields = populateMetaFields;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
        this.extraMetadata = DataSourceUtils.getExtraMetadata(properties);
        this.dataSourceInternalWriterHelper = new DataSourceInternalWriterHelper(instantTime, writeConfig, structType, jss, hadoopConfiguration, this.extraMetadata);
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
        this.dataSourceInternalWriterHelper.createInflightCommit();
        if (WriteOperationType.BULK_INSERT == this.dataSourceInternalWriterHelper.getWriteOperationType()) {
            return new HoodieBulkInsertDataInternalWriterFactory(this.dataSourceInternalWriterHelper.getHoodieTable(), this.writeConfig, this.instantTime, this.structType, this.populateMetaFields, this.arePartitionRecordsSorted);
        }
        throw new IllegalArgumentException("Write Operation Type + " + this.dataSourceInternalWriterHelper.getWriteOperationType() + " not supported ");
    }

    public boolean useCommitCoordinator() {
        return this.dataSourceInternalWriterHelper.useCommitCoordinator();
    }

    public void onDataWriterCommit(WriterCommitMessage message) {
        this.dataSourceInternalWriterHelper.onDataWriterCommit(message.toString());
    }

    public void commit(WriterCommitMessage[] messages) {
        List writeStatList = Arrays.stream(messages).map(m -> (HoodieWriterCommitMessage)((Object)m)).flatMap(m -> m.getWriteStatuses().stream().map(HoodieInternalWriteStatus::getStat)).collect(Collectors.toList());
        this.dataSourceInternalWriterHelper.commit(writeStatList);
    }

    public void abort(WriterCommitMessage[] messages) {
        this.dataSourceInternalWriterHelper.abort();
    }
}

