/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaBulkInsertHelper;

public class JavaBulkInsertCommitActionExecutor<T>
extends BaseJavaCommitActionExecutor<T> {
    private final List<HoodieRecord<T>> inputRecords;
    private final Option<BulkInsertPartitioner> bulkInsertPartitioner;

    public JavaBulkInsertCommitActionExecutor(HoodieJavaEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> inputRecords, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        this(context, config, table, instantTime, inputRecords, bulkInsertPartitioner, (Option<Map<String, String>>)Option.empty());
    }

    public JavaBulkInsertCommitActionExecutor(HoodieJavaEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> inputRecords, Option<BulkInsertPartitioner> bulkInsertPartitioner, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime, WriteOperationType.BULK_INSERT, extraMetadata);
        this.inputRecords = inputRecords;
        this.bulkInsertPartitioner = bulkInsertPartitioner;
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute() {
        try {
            return JavaBulkInsertHelper.newInstance().bulkInsert(this.inputRecords, this.instantTime, this.table, this.config, this, true, this.bulkInsertPartitioner);
        }
        catch (HoodieInsertException ie) {
            throw ie;
        }
        catch (Throwable e) {
            throw new HoodieInsertException("Failed to bulk insert for commit time " + this.instantTime, e);
        }
    }
}

