/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.LogQueryFilter;
import org.apache.hadoop.hbase.client.OnlineLogRecord;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ServiceCaller;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotView;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcChannel;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncAdmin {
    public CompletableFuture<Boolean> tableExists(TableName var1);

    default public CompletableFuture<List<TableDescriptor>> listTableDescriptors() {
        return this.listTableDescriptors(false);
    }

    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(boolean var1);

    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(Pattern var1, boolean var2);

    public CompletableFuture<List<TableDescriptor>> listTableDescriptors(List<TableName> var1);

    public CompletableFuture<List<TableDescriptor>> listTableDescriptorsByNamespace(String var1);

    default public CompletableFuture<List<TableName>> listTableNames() {
        return this.listTableNames(false);
    }

    public CompletableFuture<List<TableName>> listTableNames(boolean var1);

    public CompletableFuture<List<TableName>> listTableNames(Pattern var1, boolean var2);

    public CompletableFuture<List<TableName>> listTableNamesByNamespace(String var1);

    public CompletableFuture<TableDescriptor> getDescriptor(TableName var1);

    public CompletableFuture<Void> createTable(TableDescriptor var1);

    public CompletableFuture<Void> createTable(TableDescriptor var1, byte[] var2, byte[] var3, int var4);

    public CompletableFuture<Void> createTable(TableDescriptor var1, byte[][] var2);

    public CompletableFuture<Void> modifyTable(TableDescriptor var1);

    public CompletableFuture<Void> deleteTable(TableName var1);

    public CompletableFuture<Void> truncateTable(TableName var1, boolean var2);

    public CompletableFuture<Void> enableTable(TableName var1);

    public CompletableFuture<Void> disableTable(TableName var1);

    public CompletableFuture<Boolean> isTableEnabled(TableName var1);

    public CompletableFuture<Boolean> isTableDisabled(TableName var1);

    public CompletableFuture<Boolean> isTableAvailable(TableName var1);

    @Deprecated
    public CompletableFuture<Boolean> isTableAvailable(TableName var1, byte[][] var2);

    public CompletableFuture<Void> addColumnFamily(TableName var1, ColumnFamilyDescriptor var2);

    public CompletableFuture<Void> deleteColumnFamily(TableName var1, byte[] var2);

    public CompletableFuture<Void> modifyColumnFamily(TableName var1, ColumnFamilyDescriptor var2);

    public CompletableFuture<Void> createNamespace(NamespaceDescriptor var1);

    public CompletableFuture<Void> modifyNamespace(NamespaceDescriptor var1);

    public CompletableFuture<Void> deleteNamespace(String var1);

    public CompletableFuture<NamespaceDescriptor> getNamespaceDescriptor(String var1);

    public CompletableFuture<List<String>> listNamespaces();

    public CompletableFuture<List<NamespaceDescriptor>> listNamespaceDescriptors();

    public CompletableFuture<List<RegionInfo>> getRegions(ServerName var1);

    public CompletableFuture<List<RegionInfo>> getRegions(TableName var1);

    public CompletableFuture<Void> flush(TableName var1);

    public CompletableFuture<Void> flushRegion(byte[] var1);

    public CompletableFuture<Void> flushRegionServer(ServerName var1);

    default public CompletableFuture<Void> compact(TableName tableName) {
        return this.compact(tableName, CompactType.NORMAL);
    }

    default public CompletableFuture<Void> compact(TableName tableName, byte[] columnFamily) {
        return this.compact(tableName, columnFamily, CompactType.NORMAL);
    }

    public CompletableFuture<Void> compact(TableName var1, CompactType var2);

    public CompletableFuture<Void> compact(TableName var1, byte[] var2, CompactType var3);

    public CompletableFuture<Void> compactRegion(byte[] var1);

    public CompletableFuture<Void> compactRegion(byte[] var1, byte[] var2);

    default public CompletableFuture<Void> majorCompact(TableName tableName) {
        return this.majorCompact(tableName, CompactType.NORMAL);
    }

    default public CompletableFuture<Void> majorCompact(TableName tableName, byte[] columnFamily) {
        return this.majorCompact(tableName, columnFamily, CompactType.NORMAL);
    }

    public CompletableFuture<Void> majorCompact(TableName var1, CompactType var2);

    public CompletableFuture<Void> majorCompact(TableName var1, byte[] var2, CompactType var3);

    public CompletableFuture<Void> majorCompactRegion(byte[] var1);

    public CompletableFuture<Void> majorCompactRegion(byte[] var1, byte[] var2);

    public CompletableFuture<Void> compactRegionServer(ServerName var1);

    public CompletableFuture<Void> majorCompactRegionServer(ServerName var1);

    default public CompletableFuture<Boolean> mergeSwitch(boolean enabled) {
        return this.mergeSwitch(enabled, false);
    }

    public CompletableFuture<Boolean> mergeSwitch(boolean var1, boolean var2);

    public CompletableFuture<Boolean> isMergeEnabled();

    default public CompletableFuture<Boolean> splitSwitch(boolean enabled) {
        return this.splitSwitch(enabled, false);
    }

    public CompletableFuture<Boolean> splitSwitch(boolean var1, boolean var2);

    public CompletableFuture<Boolean> isSplitEnabled();

    @Deprecated
    default public CompletableFuture<Void> mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        return this.mergeRegions(Arrays.asList(nameOfRegionA, nameOfRegionB), forcible);
    }

    public CompletableFuture<Void> mergeRegions(List<byte[]> var1, boolean var2);

    public CompletableFuture<Void> split(TableName var1);

    public CompletableFuture<Void> splitRegion(byte[] var1);

    public CompletableFuture<Void> split(TableName var1, byte[] var2);

    public CompletableFuture<Void> splitRegion(byte[] var1, byte[] var2);

    public CompletableFuture<Void> assign(byte[] var1);

    public CompletableFuture<Void> unassign(byte[] var1, boolean var2);

    public CompletableFuture<Void> offline(byte[] var1);

    public CompletableFuture<Void> move(byte[] var1);

    public CompletableFuture<Void> move(byte[] var1, ServerName var2);

    public CompletableFuture<Void> setQuota(QuotaSettings var1);

    public CompletableFuture<List<QuotaSettings>> getQuota(QuotaFilter var1);

    default public CompletableFuture<Void> addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) {
        return this.addReplicationPeer(peerId, peerConfig, true);
    }

    public CompletableFuture<Void> addReplicationPeer(String var1, ReplicationPeerConfig var2, boolean var3);

    public CompletableFuture<Void> removeReplicationPeer(String var1);

    public CompletableFuture<Void> enableReplicationPeer(String var1);

    public CompletableFuture<Void> disableReplicationPeer(String var1);

    public CompletableFuture<ReplicationPeerConfig> getReplicationPeerConfig(String var1);

    public CompletableFuture<Void> updateReplicationPeerConfig(String var1, ReplicationPeerConfig var2);

    public CompletableFuture<Void> appendReplicationPeerTableCFs(String var1, Map<TableName, List<String>> var2);

    public CompletableFuture<Void> removeReplicationPeerTableCFs(String var1, Map<TableName, List<String>> var2);

    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers();

    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(Pattern var1);

    public CompletableFuture<List<TableCFs>> listReplicatedTableCFs();

    public CompletableFuture<Void> enableTableReplication(TableName var1);

    public CompletableFuture<Void> disableTableReplication(TableName var1);

    default public CompletableFuture<Void> snapshot(String snapshotName, TableName tableName) {
        return this.snapshot(snapshotName, tableName, SnapshotType.FLUSH);
    }

    default public CompletableFuture<Void> snapshot(String snapshotName, TableName tableName, SnapshotType type) {
        return this.snapshot(new SnapshotDescription(snapshotName, tableName, type));
    }

    public CompletableFuture<Void> snapshot(SnapshotDescription var1);

    public CompletableFuture<Boolean> isSnapshotFinished(SnapshotDescription var1);

    public CompletableFuture<Void> restoreSnapshot(String var1);

    default public CompletableFuture<Void> restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        return this.restoreSnapshot(snapshotName, takeFailSafeSnapshot, false);
    }

    public CompletableFuture<Void> restoreSnapshot(String var1, boolean var2, boolean var3);

    default public CompletableFuture<Void> cloneSnapshot(String snapshotName, TableName tableName) {
        return this.cloneSnapshot(snapshotName, tableName, false);
    }

    public CompletableFuture<Void> cloneSnapshot(String var1, TableName var2, boolean var3);

    public CompletableFuture<List<SnapshotDescription>> listSnapshots();

    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Pattern var1);

    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern var1);

    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern var1, Pattern var2);

    public CompletableFuture<Void> deleteSnapshot(String var1);

    public CompletableFuture<Void> deleteSnapshots();

    public CompletableFuture<Void> deleteSnapshots(Pattern var1);

    public CompletableFuture<Void> deleteTableSnapshots(Pattern var1);

    public CompletableFuture<Void> deleteTableSnapshots(Pattern var1, Pattern var2);

    public CompletableFuture<Void> execProcedure(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<byte[]> execProcedureWithReturn(String var1, String var2, Map<String, String> var3);

    public CompletableFuture<Boolean> isProcedureFinished(String var1, String var2, Map<String, String> var3);

    @Deprecated
    public CompletableFuture<Boolean> abortProcedure(long var1, boolean var3);

    public CompletableFuture<String> getProcedures();

    public CompletableFuture<String> getLocks();

    public CompletableFuture<Void> decommissionRegionServers(List<ServerName> var1, boolean var2);

    public CompletableFuture<List<ServerName>> listDecommissionedRegionServers();

    public CompletableFuture<Void> recommissionRegionServer(ServerName var1, List<byte[]> var2);

    public CompletableFuture<ClusterMetrics> getClusterMetrics();

    public CompletableFuture<ClusterMetrics> getClusterMetrics(EnumSet<ClusterMetrics.Option> var1);

    default public CompletableFuture<ServerName> getMaster() {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER)).thenApply(ClusterMetrics::getMasterName);
    }

    default public CompletableFuture<Collection<ServerName>> getBackupMasters() {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.BACKUP_MASTERS)).thenApply(ClusterMetrics::getBackupMasterNames);
    }

    default public CompletableFuture<Collection<ServerName>> getRegionServers() {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.SERVERS_NAME)).thenApply(ClusterMetrics::getServersName);
    }

    default public CompletableFuture<List<String>> getMasterCoprocessorNames() {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER_COPROCESSORS)).thenApply(ClusterMetrics::getMasterCoprocessorNames);
    }

    default public CompletableFuture<Integer> getMasterInfoPort() {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER_INFO_PORT)).thenApply(ClusterMetrics::getMasterInfoPort);
    }

    public CompletableFuture<Void> shutdown();

    public CompletableFuture<Void> stopMaster();

    public CompletableFuture<Void> stopRegionServer(ServerName var1);

    public CompletableFuture<Void> updateConfiguration(ServerName var1);

    public CompletableFuture<Void> updateConfiguration();

    public CompletableFuture<Void> rollWALWriter(ServerName var1);

    public CompletableFuture<Void> clearCompactionQueues(ServerName var1, Set<String> var2);

    public CompletableFuture<List<RegionMetrics>> getRegionMetrics(ServerName var1);

    public CompletableFuture<List<RegionMetrics>> getRegionMetrics(ServerName var1, TableName var2);

    public CompletableFuture<Boolean> isMasterInMaintenanceMode();

    default public CompletableFuture<CompactionState> getCompactionState(TableName tableName) {
        return this.getCompactionState(tableName, CompactType.NORMAL);
    }

    public CompletableFuture<CompactionState> getCompactionState(TableName var1, CompactType var2);

    public CompletableFuture<CompactionState> getCompactionStateForRegion(byte[] var1);

    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestamp(TableName var1);

    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestampForRegion(byte[] var1);

    public CompletableFuture<List<SecurityCapability>> getSecurityCapabilities();

    default public CompletableFuture<Boolean> balancerSwitch(boolean on) {
        return this.balancerSwitch(on, false);
    }

    public CompletableFuture<Boolean> balancerSwitch(boolean var1, boolean var2);

    default public CompletableFuture<Boolean> balance() {
        return this.balance(false);
    }

    public CompletableFuture<Boolean> balance(boolean var1);

    public CompletableFuture<Boolean> isBalancerEnabled();

    public CompletableFuture<Boolean> normalizerSwitch(boolean var1);

    public CompletableFuture<Boolean> isNormalizerEnabled();

    public CompletableFuture<Boolean> normalize();

    public CompletableFuture<Boolean> cleanerChoreSwitch(boolean var1);

    public CompletableFuture<Boolean> isCleanerChoreEnabled();

    public CompletableFuture<Boolean> runCleanerChore();

    public CompletableFuture<Boolean> catalogJanitorSwitch(boolean var1);

    public CompletableFuture<Boolean> isCatalogJanitorEnabled();

    public CompletableFuture<Integer> runCatalogJanitor();

    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> var1, ServiceCaller<S, R> var2);

    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> var1, ServiceCaller<S, R> var2, ServerName var3);

    default public CompletableFuture<List<ServerName>> listDeadServers() {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.DEAD_SERVERS)).thenApply(ClusterMetrics::getDeadServerNames);
    }

    public CompletableFuture<List<ServerName>> clearDeadServers(List<ServerName> var1);

    public CompletableFuture<CacheEvictionStats> clearBlockCache(TableName var1);

    public CompletableFuture<Void> cloneTableSchema(TableName var1, TableName var2, boolean var3);

    public CompletableFuture<Map<ServerName, Boolean>> compactionSwitch(boolean var1, List<String> var2);

    public CompletableFuture<Boolean> switchRpcThrottle(boolean var1);

    public CompletableFuture<Boolean> isRpcThrottleEnabled();

    public CompletableFuture<Boolean> exceedThrottleQuotaSwitch(boolean var1);

    public CompletableFuture<Map<TableName, Long>> getSpaceQuotaTableSizes();

    public CompletableFuture<? extends Map<TableName, ? extends SpaceQuotaSnapshotView>> getRegionServerSpaceQuotaSnapshots(ServerName var1);

    public CompletableFuture<? extends SpaceQuotaSnapshotView> getCurrentSpaceQuotaSnapshot(String var1);

    public CompletableFuture<? extends SpaceQuotaSnapshotView> getCurrentSpaceQuotaSnapshot(TableName var1);

    public CompletableFuture<Void> grant(UserPermission var1, boolean var2);

    public CompletableFuture<Void> revoke(UserPermission var1);

    public CompletableFuture<List<UserPermission>> getUserPermissions(GetUserPermissionsRequest var1);

    public CompletableFuture<List<Boolean>> hasUserPermissions(String var1, List<Permission> var2);

    default public CompletableFuture<List<Boolean>> hasUserPermissions(List<Permission> permissions) {
        return this.hasUserPermissions(null, permissions);
    }

    public CompletableFuture<Boolean> snapshotCleanupSwitch(boolean var1, boolean var2);

    public CompletableFuture<Boolean> isSnapshotCleanupEnabled();

    public CompletableFuture<List<OnlineLogRecord>> getSlowLogResponses(Set<ServerName> var1, LogQueryFilter var2);

    public CompletableFuture<List<Boolean>> clearSlowLogResponses(Set<ServerName> var1);
}

