/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.UserMetrics;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class UserMetricsBuilder {
    private final byte[] name;
    private Map<String, UserMetrics.ClientMetrics> clientMetricsMap = new HashMap<String, UserMetrics.ClientMetrics>();

    public static UserMetrics toUserMetrics(ClusterStatusProtos.UserLoad userLoad) {
        UserMetricsBuilder builder = UserMetricsBuilder.newBuilder(userLoad.getUserName().getBytes());
        userLoad.getClientMetricsList().stream().map(clientMetrics -> new ClientMetricsImpl(clientMetrics.getHostName(), clientMetrics.getReadRequestsCount(), clientMetrics.getWriteRequestsCount(), clientMetrics.getFilteredRequestsCount())).forEach(builder::addClientMetris);
        return builder.build();
    }

    public static ClusterStatusProtos.UserLoad toUserMetrics(UserMetrics userMetrics) {
        ClusterStatusProtos.UserLoad.Builder builder = ClusterStatusProtos.UserLoad.newBuilder().setUserName(userMetrics.getNameAsString());
        userMetrics.getClientMetrics().values().stream().map(clientMetrics -> ClusterStatusProtos.ClientMetrics.newBuilder().setHostName(clientMetrics.getHostName()).setWriteRequestsCount(clientMetrics.getWriteRequestsCount()).setReadRequestsCount(clientMetrics.getReadRequestsCount()).setFilteredRequestsCount(clientMetrics.getFilteredReadRequestsCount()).build()).forEach(builder::addClientMetrics);
        return builder.build();
    }

    public static UserMetricsBuilder newBuilder(byte[] name) {
        return new UserMetricsBuilder(name);
    }

    private UserMetricsBuilder(byte[] name) {
        this.name = name;
    }

    public UserMetricsBuilder addClientMetris(UserMetrics.ClientMetrics clientMetrics) {
        this.clientMetricsMap.put(clientMetrics.getHostName(), clientMetrics);
        return this;
    }

    public UserMetrics build() {
        return new UserMetricsImpl(this.name, this.clientMetricsMap);
    }

    private static class UserMetricsImpl
    implements UserMetrics {
        private final byte[] name;
        private final Map<String, UserMetrics.ClientMetrics> clientMetricsMap;

        UserMetricsImpl(byte[] name, Map<String, UserMetrics.ClientMetrics> clientMetricsMap) {
            this.name = Preconditions.checkNotNull(name);
            this.clientMetricsMap = clientMetricsMap;
        }

        @Override
        public byte[] getUserName() {
            return this.name;
        }

        @Override
        public long getReadRequestCount() {
            return this.clientMetricsMap.values().stream().map(c -> c.getReadRequestsCount()).reduce(0L, Long::sum);
        }

        @Override
        public long getWriteRequestCount() {
            return this.clientMetricsMap.values().stream().map(c -> c.getWriteRequestsCount()).reduce(0L, Long::sum);
        }

        @Override
        public Map<String, UserMetrics.ClientMetrics> getClientMetrics() {
            return this.clientMetricsMap;
        }

        @Override
        public long getFilteredReadRequests() {
            return this.clientMetricsMap.values().stream().map(c -> c.getFilteredReadRequestsCount()).reduce(0L, Long::sum);
        }

        public String toString() {
            StringBuilder sb = Strings.appendKeyValue(new StringBuilder(), "readRequestCount", this.getReadRequestCount());
            Strings.appendKeyValue(sb, "writeRequestCount", this.getWriteRequestCount());
            Strings.appendKeyValue(sb, "filteredReadRequestCount", this.getFilteredReadRequests());
            return sb.toString();
        }
    }

    public static class ClientMetricsImpl
    implements UserMetrics.ClientMetrics {
        private final long filteredReadRequestsCount;
        private final String hostName;
        private final long readRequestCount;
        private final long writeRequestCount;

        public ClientMetricsImpl(String hostName, long readRequest, long writeRequest, long filteredReadRequestsCount) {
            this.hostName = hostName;
            this.readRequestCount = readRequest;
            this.writeRequestCount = writeRequest;
            this.filteredReadRequestsCount = filteredReadRequestsCount;
        }

        @Override
        public String getHostName() {
            return this.hostName;
        }

        @Override
        public long getReadRequestsCount() {
            return this.readRequestCount;
        }

        @Override
        public long getWriteRequestsCount() {
            return this.writeRequestCount;
        }

        @Override
        public long getFilteredReadRequestsCount() {
            return this.filteredReadRequestsCount;
        }
    }
}

